/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class MapVersionsPhase
extends AbstractReleasePhase {
    private boolean convertToSnapshot;
    private boolean convertToBranch;
    private Prompter prompter;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        if (releaseDescriptor.isAutoVersionSubmodules() && ArtifactUtils.isSnapshot((String)rootProject.getVersion())) {
            MavenProject project = rootProject;
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String nextVersion = this.getNextVersion(project, projectId, releaseDescriptor, result);
            if (this.convertToSnapshot) {
                if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                    releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
                } else {
                    releaseDescriptor.mapDevelopmentVersion(projectId, nextVersion);
                }
            } else {
                releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
            }
            Iterator i = reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject subProject = (MavenProject)i.next();
                String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                if (this.convertToSnapshot) {
                    String v = ArtifactUtils.isSnapshot((String)subProject.getVersion()) ? nextVersion : subProject.getVersion();
                    if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                        releaseDescriptor.mapReleaseVersion(subProjectId, v);
                        continue;
                    }
                    releaseDescriptor.mapDevelopmentVersion(subProjectId, v);
                    continue;
                }
                releaseDescriptor.mapReleaseVersion(subProjectId, nextVersion);
            }
        } else {
            Iterator i = reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                String nextVersion = this.getNextVersion(project, projectId, releaseDescriptor, result);
                if (this.convertToSnapshot) {
                    if (releaseDescriptor.isBranchCreation() && this.convertToBranch) {
                        releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
                        continue;
                    }
                    releaseDescriptor.mapDevelopmentVersion(projectId, nextVersion);
                    continue;
                }
                releaseDescriptor.mapReleaseVersion(projectId, nextVersion);
            }
        }
        result.setResultCode(0);
        return result;
    }

    private String getNextVersion(MavenProject project, String projectId, ReleaseDescriptor releaseDescriptor, ReleaseResult result) throws ReleaseExecutionException {
        String nextVersion = null;
        DefaultVersionInfo currentVersionInfo = null;
        DefaultVersionInfo releaseVersionInfo = null;
        VersionInfo nextSnapshotVersionInfo = null;
        try {
            String nextDevVersion;
            String releaseVersion;
            releaseVersionInfo = currentVersionInfo = new DefaultVersionInfo(project.getVersion());
            if (releaseDescriptor.getDefaultReleaseVersion() != null) {
                releaseVersionInfo = new DefaultVersionInfo(releaseDescriptor.getDefaultReleaseVersion());
            }
            if (releaseDescriptor.getReleaseVersions() != null && (releaseVersion = (String)releaseDescriptor.getReleaseVersions().get(projectId)) != null) {
                releaseVersionInfo = new DefaultVersionInfo(releaseVersion);
            }
            if (releaseVersionInfo != null) {
                nextSnapshotVersionInfo = releaseVersionInfo.getNextVersion();
            }
            if (releaseDescriptor.getDefaultDevelopmentVersion() != null) {
                nextSnapshotVersionInfo = new DefaultVersionInfo(releaseDescriptor.getDefaultDevelopmentVersion());
            }
            if (releaseDescriptor.getDevelopmentVersions() != null && (nextDevVersion = (String)releaseDescriptor.getDevelopmentVersions().get(projectId)) != null) {
                nextSnapshotVersionInfo = new DefaultVersionInfo(nextDevVersion);
            }
        }
        catch (VersionParseException e) {
            String msg = "Error parsing version, cannot determine next version: " + e.getMessage();
            if (releaseDescriptor.isInteractive()) {
                this.logWarn(result, msg);
                this.logDebug(result, e.getMessage(), e);
            }
            throw new ReleaseExecutionException(msg, e);
        }
        try {
            Map relVersions;
            if (this.convertToSnapshot) {
                Map devVersions;
                if (releaseDescriptor.isBranchCreation()) {
                    if (this.convertToBranch) {
                        if (releaseDescriptor.isUpdateBranchVersions() && (ArtifactUtils.isSnapshot((String)project.getVersion()) || releaseDescriptor.isUpdateVersionsToSnapshot())) {
                            if (releaseVersionInfo != null) {
                                nextVersion = releaseVersionInfo.getSnapshotVersionString();
                            }
                            if (releaseDescriptor.isInteractive()) {
                                nextVersion = this.prompter.prompt("What is the branch version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                            } else {
                                relVersions = releaseDescriptor.getDevelopmentVersions();
                                if (relVersions.containsKey(projectId)) {
                                    nextVersion = relVersions.remove(projectId).toString();
                                }
                            }
                        } else {
                            nextVersion = project.getVersion();
                        }
                    } else if (ArtifactUtils.isSnapshot((String)project.getVersion()) && releaseDescriptor.isUpdateWorkingCopyVersions()) {
                        if (currentVersionInfo != null) {
                            nextVersion = nextSnapshotVersionInfo != null ? nextSnapshotVersionInfo.getSnapshotVersionString() : "1.0-SNAPSHOT";
                        }
                        if (releaseDescriptor.isInteractive()) {
                            nextVersion = this.prompter.prompt("What is the new working copy version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                        } else {
                            devVersions = releaseDescriptor.getDevelopmentVersions();
                            if (devVersions.containsKey(projectId)) {
                                nextVersion = devVersions.remove(projectId).toString();
                            }
                        }
                    } else {
                        nextVersion = project.getVersion();
                    }
                } else {
                    if (currentVersionInfo != null) {
                        nextVersion = nextSnapshotVersionInfo != null ? nextSnapshotVersionInfo.getSnapshotVersionString() : "1.0-SNAPSHOT";
                    }
                    if (releaseDescriptor.isInteractive()) {
                        nextVersion = this.prompter.prompt("What is the new development version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                    } else {
                        devVersions = releaseDescriptor.getDevelopmentVersions();
                        if (devVersions.containsKey(projectId)) {
                            nextVersion = devVersions.remove(projectId).toString();
                        }
                    }
                }
            } else if (ArtifactUtils.isSnapshot((String)project.getVersion())) {
                if (releaseVersionInfo != null) {
                    nextVersion = releaseVersionInfo.getReleaseVersionString();
                }
                if (releaseDescriptor.isInteractive()) {
                    nextVersion = this.prompter.prompt("What is the release version for \"" + project.getName() + "\"? (" + projectId + ")", nextVersion);
                } else {
                    relVersions = releaseDescriptor.getReleaseVersions();
                    if (relVersions.containsKey(projectId)) {
                        nextVersion = relVersions.remove(projectId).toString();
                    }
                }
            } else {
                nextVersion = project.getVersion();
            }
        }
        catch (PrompterException e) {
            throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
        }
        return nextVersion;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }
}

