/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugins.surefire.report.SurefireReportGenerator;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class SurefireReportMojo
extends AbstractMavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private MavenProject project;
    private boolean showSuccess;
    private File[] reportsDirectories;
    private File reportsDirectory;
    private List reactorProjects;
    private String outputName;
    private File xrefLocation;
    private boolean linkXRef;
    private boolean aggregate;

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.reportsDirectory != null) {
            if (this.reportsDirectories == null) {
                this.reportsDirectories = new File[]{this.reportsDirectory};
            } else {
                File[] oldReports = this.reportsDirectories;
                this.reportsDirectories = new File[oldReports.length + 1];
                System.arraycopy(oldReports, 0, this.reportsDirectories, 0, oldReports.length);
                this.reportsDirectories[oldReports.length] = this.reportsDirectory;
            }
        }
        if (this.aggregate) {
            if (!this.project.isExecutionRoot()) {
                return;
            }
            if (this.reportsDirectories == null) {
                ArrayList<File> reportsDirectoryList = new ArrayList<File>();
                Iterator i = this.reactorProjects.iterator();
                while (i.hasNext()) {
                    MavenProject subProject = (MavenProject)i.next();
                    if (this.project.equals((Object)subProject)) continue;
                    String buildDir = subProject.getBuild().getDirectory();
                    File reportsDirectory = new File(buildDir + "/surefire-reports");
                    reportsDirectoryList.add(reportsDirectory);
                }
                this.reportsDirectories = reportsDirectoryList.toArray(new File[0]);
            }
        } else if (this.reportsDirectories == null) {
            this.reportsDirectories = new File[]{new File(this.project.getBuild().getDirectory() + "/surefire-reports")};
        }
        SurefireReportGenerator report = new SurefireReportGenerator(this.reportsDirectories, locale, this.showSuccess, this.determineXrefLocation());
        report.doGenerateReport(this.getBundle(locale), this.getSink());
    }

    private String determineXrefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                Iterator reports = this.project.getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin report = (ReportPlugin)reports.next();
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Test Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.description");
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.outputName;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("surefire-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

