/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="update-subprojects")
public class UpdateSubprojectsMojo
extends AbstractScmMojo {
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    @Parameter(property="revisionKey", defaultValue="scm.revision")
    private String revisionKey;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    @Inject
    public UpdateSubprojectsMojo(ScmManager manager, SettingsDecrypter settingsDecrypter) {
        super(manager, settingsDecrypter);
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            UpdateScmResult result = this.getScmManager().update(repository, this.getFileSet(), this.getScmVersion(this.scmVersionType, this.scmVersion));
            this.checkResult((ScmResult)result);
            if (result instanceof UpdateScmResultWithRevision) {
                this.getLog().info((CharSequence)("Storing revision in '" + this.revisionKey + "' project property."));
                if (this.project.getProperties() != null) {
                    this.project.getProperties().put(this.revisionKey, ((UpdateScmResultWithRevision)result).getRevision());
                }
            }
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run update command : ", (Exception)e);
        }
    }
}

