/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="tag", aggregator=true)
public class TagMojo
extends AbstractScmMojo {
    @Parameter(property="tag", required=true)
    private String tag;
    @Parameter(property="message")
    private String message;
    @Parameter(property="timestampFormat", defaultValue="yyyyMMddHHmmss")
    private String timestampFormat;
    @Parameter(property="addTimestamp", defaultValue="false")
    private boolean addTimestamp;
    @Parameter(property="timestampPosition", defaultValue="end")
    private String timestampPosition;
    @Parameter(property="timestampPrefix", defaultValue="-")
    private String timestampPrefix;
    @Parameter(property="remoteTagging", defaultValue="true")
    private boolean remoteTagging;
    @Parameter(property="pinExternals", defaultValue="false")
    private boolean pinExternals;
    @Parameter(property="sign", defaultValue="false")
    private boolean sign;
    @Parameter(property="signOption")
    private CommandParameters.SignOption signOption = CommandParameters.SignOption.DEFAULT;

    @Inject
    public TagMojo(ScmManager manager, SettingsDecrypter settingsDecrypter) {
        super(manager, settingsDecrypter);
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            SimpleDateFormat dateFormat = null;
            String tagTimestamp = "";
            String finalTag = this.tag;
            if (this.addTimestamp) {
                try {
                    this.getLog().debug((CharSequence)("Using timestamp pattern '" + this.timestampFormat + "'"));
                    dateFormat = new SimpleDateFormat(this.timestampFormat);
                    tagTimestamp = dateFormat.format(new Date());
                    this.getLog().debug((CharSequence)("Using timestamp '" + tagTimestamp + "'"));
                }
                catch (IllegalArgumentException e) {
                    String msg = "The timestamp format '" + this.timestampFormat + "' is invalid.";
                    throw new MojoExecutionException(msg, (Exception)e);
                }
                finalTag = "end".equals(this.timestampPosition) ? finalTag + this.timestampPrefix + tagTimestamp : tagTimestamp + this.timestampPrefix + finalTag;
            }
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            finalTag = provider.sanitizeTagName(finalTag);
            this.getLog().debug((CharSequence)("Final Tag Name: '" + finalTag + "'"));
            ScmTagParameters scmTagParameters = new ScmTagParameters(this.message);
            scmTagParameters.setRemoteTagging(this.remoteTagging);
            scmTagParameters.setPinExternals(this.pinExternals);
            if (this.signOption != null) {
                scmTagParameters.setSignOption(this.signOption);
            } else if (this.sign) {
                this.getLog().warn((CharSequence)"The 'sign' parameter is deprecated, use 'signOption' instead.");
                scmTagParameters.setSign(this.sign);
            }
            TagScmResult result = provider.tag(repository, this.getFileSet(), finalTag, scmTagParameters);
            this.checkResult((ScmResult)result);
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run tag command : ", (Exception)e);
        }
    }
}

