/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.reactor;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.reactor.MissingProjectException;
import org.apache.maven.plugin.reactor.NonReactorException;
import org.apache.maven.plugin.reactor.RelativePather;
import org.apache.maven.plugin.reactor.SimpleInvoker;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.shared.invoker.Invoker;

@Mojo(name="resume", aggregator=true, defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class ResumeMojo
extends AbstractMojo {
    @Parameter(property="project.collectedProjects")
    List collectedProjects;
    @Parameter(property="basedir")
    File baseDir;
    @Parameter(property="make.group", defaultValue="${project.groupId}")
    String continueFromGroup;
    @Parameter(property="fromArtifact", defaultValue="null", required=true)
    String continueFromProject;
    @Parameter(property="from", defaultValue="null", required=true)
    File continueFromFolder;
    @Parameter(property="make.goals", defaultValue="install")
    String goals;
    @Component
    Invoker invoker;
    @Parameter(property="make.printOnly")
    boolean printOnly = false;
    @Component
    SimpleInvoker simpleInvoker;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] reactorIncludes;
        if ("null".equals(this.continueFromProject)) {
            this.continueFromProject = null;
        }
        if (new File("null").getAbsoluteFile().equals(this.continueFromFolder)) {
            this.continueFromFolder = null;
        }
        if (this.continueFromFolder == null && this.continueFromProject == null) {
            throw new MojoFailureException("You must specify either a folder or a project with -Dfrom=baz/bar or -DfromArtifact=com.mycompany:foo (groupId is optional)");
        }
        if (this.continueFromFolder != null && this.continueFromProject != null) {
            throw new MojoFailureException("You can't specify both a folder (" + this.continueFromFolder + ") and an artifact (" + this.continueFromProject + ")");
        }
        if (this.continueFromFolder != null && !this.continueFromFolder.exists()) {
            throw new MojoFailureException("Folder doesn't exist: " + this.continueFromFolder.getAbsolutePath());
        }
        try {
            int i;
            if (this.collectedProjects.size() == 0) {
                throw new NonReactorException();
            }
            ProjectSorter ps = new ProjectSorter(this.collectedProjects);
            List sortedProjects = ps.getSortedProjects();
            String projectName = null;
            if (this.continueFromProject != null && (projectName = this.continueFromProject).indexOf(58) != -1) {
                int index = this.continueFromProject.indexOf(58);
                this.continueFromGroup = this.continueFromProject.substring(0, index);
                projectName = this.continueFromProject.substring(index + 1);
            }
            boolean found = false;
            for (i = 0; i < sortedProjects.size(); ++i) {
                MavenProject mp = (MavenProject)sortedProjects.get(i);
                if (this.continueFromFolder == null) {
                    if (!this.continueFromGroup.equals(mp.getGroupId()) || !projectName.equals(mp.getArtifactId())) continue;
                    found = true;
                    break;
                }
                if (!this.continueFromFolder.equals(mp.getFile().getParentFile())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new MissingProjectException(this.continueFromGroup + ":" + projectName);
            }
            reactorIncludes = new String[sortedProjects.size() - i];
            for (int j = i; j < sortedProjects.size(); ++j) {
                String path;
                MavenProject mp = (MavenProject)sortedProjects.get(j);
                reactorIncludes[j - i] = path = RelativePather.getRelativePath(this.baseDir, mp.getFile());
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem generating dependency tree", e);
        }
        this.simpleInvoker.runReactor(reactorIncludes, Arrays.asList(this.goals.split(",")), this.invoker, this.printOnly, this.getLog());
    }
}

