/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.rar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.rar.RarResource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="rar", threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class RarMojo
extends AbstractMojo {
    private static final String RA_XML_URI = "META-INF/ra.xml";
    @Parameter(defaultValue="${basedir}/src/main/rar", required=true)
    private File rarSourceDirectory;
    @Parameter(defaultValue="${basedir}/src/main/rar/META-INF/ra.xml")
    private File raXmlFile;
    @Parameter(defaultValue="true")
    private Boolean includeJar;
    @Parameter(defaultValue="${basedir}/src/main/rar/META-INF/MANIFEST.MF")
    private File manifestFile;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private String workDirectory;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Parameter(property="maven.rar.classifier", defaultValue="")
    private String classifier;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="maven.rar.filterRarSourceDirectory", defaultValue="false")
    private boolean filterRarSourceDirectory;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="maven.resources.escapeWindowsPaths", defaultValue="true")
    protected boolean escapeWindowsPaths;
    @Parameter(property="maven.resources.escapeString")
    protected String escapeString;
    @Parameter(property="maven.resources.overwrite", defaultValue="false")
    private boolean overwrite;
    @Parameter(property="maven.resources.includeEmptyDirs", defaultValue="false")
    protected boolean includeEmptyDirs;
    @Parameter(property="maven.resources.supportMultiLineFiltering", defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter
    protected LinkedHashSet<String> delimiters;
    @Parameter
    protected List<String> filters;
    @Parameter
    protected List<String> nonFilteredFileExtensions;
    @Parameter
    protected List<RarResource> rarResources;
    @Parameter(property="maven.rar.warnOnMissingRaXml", defaultValue="true")
    protected boolean warnOnMissingRaXml;
    @Parameter(property="maven.rar.skip")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    private final JarArchiver jarArchiver;
    protected final MavenResourcesFiltering mavenResourcesFiltering;
    private final MavenProjectHelper projectHelper;
    private File buildDir;

    @Inject
    public RarMojo(JarArchiver jarArchiver, MavenResourcesFiltering mavenResourcesFiltering, MavenProjectHelper projectHelper) {
        this.jarArchiver = jarArchiver;
        this.mavenResourcesFiltering = mavenResourcesFiltering;
        this.projectHelper = projectHelper;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping rar generation.");
            return;
        }
        try {
            File generatedJarFile;
            if (this.includeJar.booleanValue() && (generatedJarFile = new File(this.outputDirectory, this.finalName + ".jar")).exists()) {
                this.getLog().info((CharSequence)("Including generated jar file[" + generatedJarFile.getName() + "]"));
                FileUtils.copyFileToDirectory((File)generatedJarFile, (File)this.getBuildDir());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated Jar file", (Exception)e);
        }
        try {
            Set artifacts = this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                if (artifact.isOptional() || !filter.include(artifact) || !artifact.getArtifactHandler().isAddedToClasspath()) continue;
                this.getLog().info((CharSequence)("Copying artifact[" + artifact.getGroupId() + ", " + artifact.getId() + ", " + artifact.getScope() + "]"));
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)this.getBuildDir());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying RAR dependencies", (Exception)e);
        }
        this.resourceHandling();
        try {
            this.includeCustomRaXmlFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying ra.xml file", (Exception)e);
        }
        File ddFile = new File(this.getBuildDir(), RA_XML_URI);
        if (!ddFile.exists() && this.warnOnMissingRaXml) {
            this.getLog().warn((CharSequence)("Connector deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist."));
        }
        File rarFile = RarMojo.getRarFile(this.outputDirectory, this.finalName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setCreatedBy("Maven RAR Plugin", "org.apache.maven.plugins", "maven-rar-plugin");
        archiver.setOutputFile(rarFile);
        archiver.configureReproducibleBuild(this.outputTimestamp);
        try {
            this.includeCustomManifestFile();
            archiver.getArchiver().addDirectory(this.getBuildDir());
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (IOException | DependencyResolutionRequiredException | ManifestException e) {
            throw new MojoExecutionException("Error assembling RAR", (Exception)e);
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "rar", this.classifier, rarFile);
        } else {
            this.project.getArtifact().setFile(rarFile);
        }
    }

    private void resourceHandling() throws MojoExecutionException {
        Resource resource = new Resource();
        resource.setDirectory(this.rarSourceDirectory.getAbsolutePath());
        resource.setTargetPath(this.getBuildDir().getAbsolutePath());
        resource.setFiltering(this.filterRarSourceDirectory);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(resource);
        if (this.rarResources != null && !this.rarResources.isEmpty()) {
            resources.addAll(this.rarResources);
        }
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, this.getBuildDir(), this.project, this.encoding, this.filters, Collections.emptyList(), this.session);
        mavenResourcesExecution.setEscapeWindowsPaths(this.escapeWindowsPaths);
        mavenResourcesExecution.setInjectProjectBuildFilters(false);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        mavenResourcesExecution.setOverwrite(this.overwrite);
        mavenResourcesExecution.setIncludeEmptyDirs(this.includeEmptyDirs);
        mavenResourcesExecution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
        mavenResourcesExecution.setDelimiters(this.delimiters, this.useDefaultDelimiters);
        if (this.nonFilteredFileExtensions != null) {
            mavenResourcesExecution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
        }
        try {
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error copying RAR resources", (Exception)((Object)e));
        }
    }

    protected File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = new File(this.workDirectory);
        }
        return this.buildDir;
    }

    protected static File getRarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (!classifier.trim().isEmpty() && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".rar");
    }

    private void includeCustomManifestFile() throws IOException {
        File customManifestFile = this.manifestFile;
        if (!customManifestFile.exists()) {
            this.getLog().info((CharSequence)("Could not find manifest file: " + this.manifestFile + " - Generating one"));
        } else {
            this.getLog().info((CharSequence)("Including custom manifest file[" + customManifestFile + "]"));
            this.archive.setManifestFile(customManifestFile);
            File metaInfDir = new File(this.getBuildDir(), "META-INF");
            FileUtils.copyFileToDirectory((File)customManifestFile, (File)metaInfDir);
        }
    }

    private void includeCustomRaXmlFile() throws IOException {
        if (this.raXmlFile == null) {
            return;
        }
        File raXml = this.raXmlFile;
        if (raXml.exists()) {
            this.getLog().info((CharSequence)("Using ra.xml " + this.raXmlFile));
            File metaInfDir = new File(this.getBuildDir(), "META-INF");
            FileUtils.copyFileToDirectory((File)raXml, (File)metaInfDir);
        }
    }
}

