/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="scm")
public class ScmReport
extends AbstractProjectInfoReport {
    @Component
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project.artifactId}")
    private String checkoutDirectoryName;
    @Parameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @Parameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @Parameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;
    @Parameter(defaultValue="${project.scm.tag}")
    private String scmTag;

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            Scm scm = this.getProject().getModel().getScm();
            boolean bl = result = scm != null;
            if (result && (this.anonymousConnection == null || this.anonymousConnection.isEmpty()) && (this.developerConnection == null || this.developerConnection.isEmpty()) && StringUtils.isEmpty((String)scm.getUrl())) {
                result = false;
            }
        }
        return result;
    }

    public void executeReport(Locale locale) {
        ScmRenderer r = new ScmRenderer(this.getLog(), this.scmManager, this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection, this.scmTag);
        r.render();
    }

    public String getOutputName() {
        return "scm";
    }

    @Override
    protected String getI18Nsection() {
        return "scm";
    }

    private static class ScmRenderer
    extends AbstractProjectInfoRenderer {
        private static final String LS = System.lineSeparator();
        private Log log;
        private Model model;
        private ScmManager scmManager;
        private String anonymousConnection;
        private String devConnection;
        private String checkoutDirectoryName;
        private String webAccessUrl;
        private String scmTag;

        ScmRenderer(Log log, ScmManager scmManager, Sink sink, Model model, I18N i18n, Locale locale, String checkoutDirName, String webAccessUrl, String anonymousConnection, String devConnection, String scmTag) {
            super(sink, i18n, locale);
            this.log = log;
            this.scmManager = scmManager;
            this.model = model;
            this.checkoutDirectoryName = checkoutDirName;
            this.webAccessUrl = webAccessUrl;
            this.anonymousConnection = anonymousConnection;
            this.devConnection = devConnection;
            this.scmTag = scmTag;
        }

        @Override
        protected String getI18Nsection() {
            return "scm";
        }

        protected void renderBody() {
            Scm scm = this.model.getScm();
            if (scm == null || (this.anonymousConnection == null || this.anonymousConnection.isEmpty()) && (this.devConnection == null || this.devConnection.isEmpty()) && StringUtils.isEmpty((String)scm.getUrl())) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("noscm"));
                this.endSection();
                return;
            }
            ScmRepository anonymousRepository = this.getScmRepository(this.anonymousConnection);
            ScmRepository devRepository = this.getScmRepository(this.devConnection);
            this.renderOverviewSection(anonymousRepository, devRepository);
            this.renderWebAccessSection(this.webAccessUrl);
            this.renderAnonymousAccessSection(anonymousRepository);
            this.renderDeveloperAccessSection(devRepository);
            this.renderAccessBehindFirewallSection(devRepository);
            this.renderAccessThroughProxySection(anonymousRepository, devRepository);
        }

        private void renderOverviewSection(ScmRepository anonymousRepository, ScmRepository devRepository) {
            this.startSection(this.getI18nString("overview.title"));
            if (ScmRenderer.isScmSystem(anonymousRepository, "git") || ScmRenderer.isScmSystem(devRepository, "git")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("git.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "hg") || ScmRenderer.isScmSystem(devRepository, "hg")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("hg.intro"));
                this.sink.paragraph_();
            } else if (ScmRenderer.isScmSystem(anonymousRepository, "svn") || ScmRenderer.isScmSystem(devRepository, "svn")) {
                this.sink.paragraph();
                this.linkPatternedText(this.getI18nString("svn.intro"));
                this.sink.paragraph_();
            } else {
                this.paragraph(this.getI18nString("general.intro"));
            }
            this.endSection();
        }

        private void renderWebAccessSection(String scmUrl) {
            this.startSection(this.getI18nString("webaccess.title"));
            if (scmUrl == null || scmUrl.isEmpty()) {
                this.paragraph(this.getI18nString("webaccess.nourl"));
            } else {
                this.paragraph(this.getI18nString("webaccess.url"));
                this.verbatimLink(scmUrl, scmUrl);
            }
            this.endSection();
        }

        private void renderAnonymousAccessSection(ScmRepository anonymousRepository) {
            if (this.anonymousConnection == null || this.anonymousConnection.isEmpty()) {
                return;
            }
            this.startSection(this.getI18nString("anonymousaccess.title"));
            if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "git")) {
                GitScmProviderRepository gitRepo = (GitScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessGit(gitRepo);
            } else if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "hg")) {
                HgScmProviderRepository hgRepo = (HgScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessMercurial(hgRepo);
            } else if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)anonymousRepository.getProviderRepository();
                this.anonymousAccessSubversion(svnRepo);
            } else {
                this.paragraph(this.getI18nString("anonymousaccess.general.intro"));
                this.verbatimText(this.anonymousConnection.substring(4));
            }
            this.endSection();
        }

        private void renderDeveloperAccessSection(ScmRepository devRepository) {
            if (this.devConnection == null || this.devConnection.isEmpty()) {
                return;
            }
            this.startSection(this.getI18nString("devaccess.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "git")) {
                GitScmProviderRepository gitRepo = (GitScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessGit(gitRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "hg")) {
                HgScmProviderRepository hgRepo = (HgScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessMercurial(hgRepo);
            } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.developerAccessSubversion(svnRepo);
            } else {
                this.paragraph(this.getI18nString("devaccess.general.intro"));
                this.verbatimText(this.devConnection.substring(4));
            }
            this.endSection();
        }

        private void renderAccessBehindFirewallSection(ScmRepository devRepository) {
            this.startSection(this.getI18nString("accessbehindfirewall.title"));
            if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
                this.paragraph(this.getI18nString("accessbehindfirewall.svn.intro"));
                this.verbatimText("$ svn checkout " + svnRepo.getUrl() + " " + this.checkoutDirectoryName);
            } else {
                this.paragraph(this.getI18nString("accessbehindfirewall.general.intro"));
            }
            this.endSection();
        }

        private void renderAccessThroughProxySection(ScmRepository anonymousRepository, ScmRepository devRepository) {
            if (ScmRenderer.isScmSystem(anonymousRepository, "svn") || ScmRenderer.isScmSystem(devRepository, "svn")) {
                this.startSection(this.getI18nString("accessthroughtproxy.title"));
                this.paragraph(this.getI18nString("accessthroughtproxy.svn.intro1"));
                this.paragraph(this.getI18nString("accessthroughtproxy.svn.intro2"));
                this.paragraph(this.getI18nString("accessthroughtproxy.svn.intro3"));
                this.verbatimText("[global]" + LS + "http-proxy-host = your.proxy.name" + LS + "http-proxy-port = 3128" + LS);
                this.endSection();
            }
        }

        private void gitClone(String url) {
            int index = url.indexOf(".git/");
            if (index > 0) {
                url = url.substring(0, index + 4);
            }
            boolean head = this.scmTag == null || this.scmTag.isEmpty() || "HEAD".equals(this.scmTag);
            this.verbatimText("$ git clone " + (head ? "" : "--branch " + this.scmTag + ' ') + url);
        }

        private void anonymousAccessGit(GitScmProviderRepository gitRepo) {
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("anonymousaccess.git.intro"));
            this.sink.paragraph_();
            this.gitClone(gitRepo.getFetchUrl());
        }

        private void anonymousAccessMercurial(HgScmProviderRepository hgRepo) {
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("anonymousaccess.hg.intro"));
            this.sink.paragraph_();
            this.verbatimText("$ hg clone " + hgRepo.getURI());
        }

        private void developerAccessGit(GitScmProviderRepository gitRepo) {
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("devaccess.git.intro"));
            this.sink.paragraph_();
            this.gitClone(gitRepo.getPushUrl());
        }

        private void developerAccessMercurial(HgScmProviderRepository hgRepo) {
            this.sink.paragraph();
            this.linkPatternedText(this.getI18nString("devaccess.hg.intro"));
            this.sink.paragraph_();
            this.verbatimText("$ hg clone " + hgRepo.getURI());
        }

        private void anonymousAccessSubversion(SvnScmProviderRepository svnRepo) {
            this.paragraph(this.getI18nString("anonymousaccess.svn.intro"));
            this.verbatimText("$ svn checkout " + svnRepo.getUrl() + " " + this.checkoutDirectoryName);
        }

        private void developerAccessSubversion(SvnScmProviderRepository svnRepo) {
            if (svnRepo.getUrl() != null) {
                if (svnRepo.getUrl().startsWith("https://")) {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.https"));
                } else if (svnRepo.getUrl().startsWith("svn://")) {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.svn"));
                } else if (svnRepo.getUrl().startsWith("svn+ssh://")) {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.svnssh"));
                } else {
                    this.paragraph(this.getI18nString("devaccess.svn.intro1.other"));
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
            this.verbatimText(sb.toString());
            this.paragraph(this.getI18nString("devaccess.svn.intro2"));
            sb = new StringBuilder();
            sb.append("$ svn commit --username your-username -m \"A message\"");
            this.verbatimText(sb.toString());
        }

        public ScmRepository getScmRepository(String scmUrl) {
            ScmRepository repo;
            block9: {
                if (scmUrl == null || scmUrl.isEmpty()) {
                    return null;
                }
                repo = null;
                ArrayList<String> messages = new ArrayList<String>();
                try {
                    messages.addAll(this.scmManager.validateScmRepository(scmUrl));
                }
                catch (Exception e) {
                    messages.add(e.getMessage());
                }
                if (!messages.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    boolean isIntroAdded = false;
                    for (String msg : messages) {
                        if (msg.startsWith("No such provider")) continue;
                        if (!isIntroAdded) {
                            sb.append("This SCM url '");
                            sb.append(scmUrl);
                            sb.append("' is invalid due to the following errors:");
                            sb.append(LS);
                            isIntroAdded = true;
                        }
                        sb.append(" * ");
                        sb.append(msg);
                        sb.append(LS);
                    }
                    if (StringUtils.isNotEmpty((String)sb.toString())) {
                        sb.append("For more information about SCM URL Format, please refer to: http://maven.apache.org/scm/scm-url-format.html");
                        throw new IllegalArgumentException(sb.toString());
                    }
                }
                try {
                    repo = this.scmManager.makeScmRepository(scmUrl);
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            return repo;
        }

        private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
            if (scmProvider == null || scmProvider.isEmpty()) {
                return false;
            }
            return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
        }
    }
}

