/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Organization;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="summary")
public class ProjectSummaryReport
extends AbstractProjectInfoReport {
    protected void executeReport(Locale locale) throws MavenReportException {
        new ProjectSummaryRenderer(this.getSink(), locale).render();
    }

    public String getOutputName() {
        return "project-summary";
    }

    protected String getI18Nsection() {
        return "summary";
    }

    private class ProjectSummaryRenderer
    extends AbstractProjectInfoRenderer {
        ProjectSummaryRenderer(Sink sink, Locale locale) {
            super(sink, ProjectSummaryReport.this.getI18N(locale), locale);
        }

        protected String getI18Nsection() {
            return "summary";
        }

        protected void renderBody() {
            this.startSection(this.getTitle());
            this.startSection(this.getI18nString("general.title"));
            this.startTable();
            this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
            this.tableRow(new String[]{this.getI18nString("general.name"), ProjectSummaryReport.this.project.getName()});
            this.tableRow(new String[]{this.getI18nString("general.description"), ProjectSummaryReport.this.project.getDescription()});
            this.tableRowWithLink(new String[]{this.getI18nString("general.homepage"), ProjectSummaryReport.this.project.getUrl()});
            this.endTable();
            this.endSection();
            this.startSection(this.getI18nString("organization.title"));
            Organization organization = ProjectSummaryReport.this.project.getOrganization();
            if (organization == null) {
                this.paragraph(this.getI18nString("noorganization"));
            } else {
                this.startTable();
                this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
                this.tableRow(new String[]{this.getI18nString("organization.name"), organization.getName()});
                this.tableRowWithLink(new String[]{this.getI18nString("organization.url"), organization.getUrl()});
                this.endTable();
            }
            this.endSection();
            this.startSection(this.getI18nString("build.title"));
            this.startTable();
            this.tableHeader(new String[]{this.getI18nString("field"), this.getI18nString("value")});
            this.tableRow(new String[]{this.getI18nString("build.groupid"), ProjectSummaryReport.this.project.getGroupId()});
            this.tableRow(new String[]{this.getI18nString("build.artifactid"), ProjectSummaryReport.this.project.getArtifactId()});
            this.tableRow(new String[]{this.getI18nString("build.version"), ProjectSummaryReport.this.project.getVersion()});
            this.tableRow(new String[]{this.getI18nString("build.type"), ProjectSummaryReport.this.project.getPackaging()});
            if (this.isJavaProject(ProjectSummaryReport.this.project)) {
                this.tableRow(new String[]{this.getI18nString("build.jdk"), this.getMinimumJavaVersion()});
            }
            this.endTable();
            this.endSection();
            DistributionManagement distributionManagement = ProjectSummaryReport.this.project.getDistributionManagement();
            if (distributionManagement != null && StringUtils.isNotEmpty((String)distributionManagement.getDownloadUrl())) {
                this.startSection(this.getI18nString("download"));
                this.link(distributionManagement.getDownloadUrl(), distributionManagement.getDownloadUrl());
                this.endSection();
            }
            this.endSection();
        }

        private String getMinimumJavaVersion() {
            Xpp3Dom pluginConfig = ProjectSummaryReport.this.project.getGoalConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", null, null);
            String source = null;
            String target = null;
            String compilerVersion = null;
            if (pluginConfig != null) {
                source = this.getChildValue(pluginConfig, "source");
                target = this.getChildValue(pluginConfig, "target");
                String fork = this.getChildValue(pluginConfig, "fork");
                if ("true".equalsIgnoreCase(fork)) {
                    compilerVersion = this.getChildValue(pluginConfig, "compilerVersion");
                }
            }
            String minimumJavaVersion = compilerVersion;
            if (target != null) {
                minimumJavaVersion = target;
            } else if (source != null) {
                minimumJavaVersion = source;
            } else if (compilerVersion != null) {
                minimumJavaVersion = compilerVersion;
            }
            return minimumJavaVersion;
        }

        private String getChildValue(Xpp3Dom parent, String childName) {
            if (parent == null) {
                return null;
            }
            Xpp3Dom child = parent.getChild(childName);
            if (child == null) {
                return null;
            }
            String value = child.getValue();
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            return value.trim();
        }

        private void tableRowWithLink(String[] content) {
            this.sink.tableRow();
            for (int ctr = 0; ctr < content.length; ++ctr) {
                String cell = content[ctr];
                this.sink.tableCell();
                if (StringUtils.isEmpty((String)cell)) {
                    this.sink.text("-");
                } else if (ctr == content.length - 1 && cell.length() > 0) {
                    this.sink.link(cell);
                    this.sink.text(cell);
                    this.sink.link_();
                } else {
                    this.sink.text(cell);
                }
                this.sink.tableCell_();
            }
            this.sink.tableRow_();
        }

        private boolean isJavaProject(MavenProject project) {
            Xpp3Dom pluginConfig;
            String packaging = project.getPackaging().trim().toLowerCase(Locale.ENGLISH);
            if (packaging.equals("pom")) {
                return false;
            }
            if (packaging.equals("jar") || packaging.equals("ear") || packaging.equals("war") || packaging.equals("rar") || packaging.equals("sar") || packaging.equals("har") || packaging.equals("par") || packaging.equals("ejb")) {
                return true;
            }
            File sourceDir = new File(project.getBuild().getSourceDirectory());
            if (sourceDir.exists()) {
                try {
                    if (FileUtils.getFileNames((File)sourceDir, (String)"**/*.java", null, (boolean)false).size() > 0) {
                        return true;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return (pluginConfig = project.getGoalConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", null, null)) != null;
        }
    }
}

