/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.maven.plugins.pmd.ExcludeDuplicationsFromFile;
import org.apache.maven.plugins.pmd.exec.CpdExecutor;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CpdReportConsumer
implements Consumer<CPDReport> {
    private static final Logger LOG = LoggerFactory.getLogger(CpdReportConsumer.class);
    private final CpdRequest request;
    private final ExcludeDuplicationsFromFile excludeDuplicationsFromFile;

    CpdReportConsumer(CpdRequest request, ExcludeDuplicationsFromFile excludeDuplicationsFromFile) {
        this.request = request;
        this.excludeDuplicationsFromFile = excludeDuplicationsFromFile;
    }

    @Override
    public void accept(CPDReport report) {
        try {
            this.writeXmlReport(report);
            String format = this.request.getFormat();
            if (!"html".equals(format) && !"xml".equals(format)) {
                this.writeFormattedReport(report);
            }
        }
        catch (IOException | MavenReportException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeXmlReport(CPDReport cpd) throws IOException {
        File targetFile = this.writeReport(cpd, (CPDReportRenderer)new XMLRenderer(this.request.getOutputEncoding()), "xml");
        if (this.request.isIncludeXmlInReports()) {
            File outputDirectory = new File(this.request.getReportOutputDirectory());
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new IOException("Couldn't create report output directory: " + outputDirectory);
            }
            FileUtils.copyFile((File)targetFile, (File)new File(outputDirectory, "cpd.xml"));
        }
    }

    private void writeFormattedReport(CPDReport cpd) throws IOException, MavenReportException {
        CPDReportRenderer renderer = CpdExecutor.createRenderer(this.request.getFormat(), this.request.getOutputEncoding());
        this.writeReport(cpd, renderer, this.request.getFormat());
    }

    private File writeReport(CPDReport cpd, CPDReportRenderer renderer, String extension) throws IOException {
        File file;
        block10: {
            if (renderer == null) {
                return null;
            }
            File targetDir = new File(this.request.getTargetDirectory());
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                throw new IOException("Couldn't create report target directory: " + targetDir);
            }
            File targetFile = new File(targetDir, "cpd." + extension);
            BufferedWriter writer = Files.newBufferedWriter(targetFile.toPath(), Charset.forName(this.request.getOutputEncoding()), new OpenOption[0]);
            try {
                renderer.render(cpd.filterMatches(this.filterMatches()), (Writer)writer);
                file = targetFile;
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                    throw new UnsupportedEncodingException(ex.getMessage());
                }
            }
            ((Writer)writer).close();
        }
        return file;
    }

    private Predicate<Match> filterMatches() {
        return match -> {
            LOG.debug("Filtering duplications. Using {} configured exclusions.", (Object)this.excludeDuplicationsFromFile.countExclusions());
            if (this.excludeDuplicationsFromFile.isExcludedFromFailure((Match)match)) {
                LOG.debug("Excluded {} duplications.", match);
                return false;
            }
            return true;
        };
    }
}

