/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.markup.Markup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.report.AbstractPluginReportRenderer;
import org.apache.maven.plugin.plugin.report.RequirementsHistory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.i18n.I18N;

class PluginOverviewRenderer
extends AbstractPluginReportRenderer {
    private final List<RequirementsHistory> requirementsHistories;
    private final PluginDescriptor pluginDescriptor;
    private final boolean hasExtensionsToLoad;

    PluginOverviewRenderer(Sink sink, I18N i18n, Locale locale, MavenProject project, List<RequirementsHistory> requirementsHistories, PluginDescriptor pluginDescriptor, boolean hasExtensionsToLoad) {
        super(sink, locale, i18n, project);
        this.requirementsHistories = requirementsHistories;
        this.pluginDescriptor = pluginDescriptor;
        this.hasExtensionsToLoad = hasExtensionsToLoad;
    }

    protected void renderBody() {
        this.startSection(this.getTitle());
        if (this.pluginDescriptor.getMojos() == null || this.pluginDescriptor.getMojos().size() <= 0) {
            this.paragraph(this.getI18nString("goals.nogoal"));
            this.endSection();
            return;
        }
        boolean hasMavenReport = false;
        for (MojoDescriptor mojo : this.pluginDescriptor.getMojos()) {
            if (!PluginUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) continue;
            hasMavenReport = true;
            break;
        }
        this.paragraph(this.getI18nString("description"));
        this.renderGoalsSection(hasMavenReport);
        this.renderSystemRequirementsSection();
        this.renderRequirementsHistoriesSection();
        this.renderUsageSection(hasMavenReport);
        this.endSection();
    }

    private void renderGoalsSection(boolean hasMavenReport) {
        this.startSection(this.getI18nString("goals"));
        this.paragraph(this.getI18nString("goals.intro"));
        this.startTable();
        String goalColumnName = this.getI18nString("goals.column.goal");
        String isMavenReport = this.getI18nString("goals.column.isMavenReport");
        String descriptionColumnName = this.getI18nString("goals.column.description");
        if (hasMavenReport) {
            this.tableHeader(new String[]{goalColumnName, isMavenReport, descriptionColumnName});
        } else {
            this.tableHeader(new String[]{goalColumnName, descriptionColumnName});
        }
        ArrayList mojos = new ArrayList();
        mojos.addAll(this.pluginDescriptor.getMojos());
        PluginUtils.sortMojos(mojos);
        for (MojoDescriptor mojo : mojos) {
            this.sink.tableRow();
            String goalName = mojo.getFullGoalName();
            String goalDocumentationLink = "./" + mojo.getGoal() + "-mojo.html";
            this.sink.tableCell();
            this.link(goalDocumentationLink, goalName);
            this.sink.tableCell_();
            if (hasMavenReport) {
                if (PluginUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) {
                    this.tableCell(this.getI18nString("isReport"));
                } else {
                    this.tableCell(this.getI18nString("isNotReport"));
                }
            }
            this.sink.tableCell();
            if (StringUtils.isNotEmpty((CharSequence)mojo.getDeprecated())) {
                this.sink.division();
                this.sink.inline(SinkEventAttributeSet.Semantics.STRONG);
                this.sink.text(this.getI18nString("goal.deprecated"));
                this.sink.text(".");
                this.sink.inline_();
                this.sink.text(" ");
                this.sink.rawText(mojo.getDeprecated());
                this.sink.division_();
                this.sink.lineBreak();
            }
            String description = StringUtils.isNotEmpty((CharSequence)mojo.getDescription()) ? mojo.getDescription() : this.getI18nString("goal.nodescription");
            this.sink.rawText(description);
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.endTable();
        this.endSection();
    }

    private void renderSystemRequirementsSection() {
        this.startSection(this.getI18nString("systemrequirements"));
        this.paragraph(this.getI18nString("systemrequirements.intro"));
        this.startTable();
        String maven = RequirementsHistory.discoverMavenRequirement(this.project, this.pluginDescriptor);
        this.sink.tableRow();
        this.tableCell(this.getI18nString("systemrequirements.maven"));
        this.tableCell(maven != null ? maven : this.getI18nString("systemrequirements.nominimum"));
        this.sink.tableRow_();
        String jdk = RequirementsHistory.discoverJdkRequirement(this.project, this.pluginDescriptor);
        this.sink.tableRow();
        this.tableCell(this.getI18nString("systemrequirements.jdk"));
        this.tableCell(jdk != null ? jdk : this.getI18nString("systemrequirements.nominimum"));
        this.sink.tableRow_();
        this.endTable();
        this.endSection();
    }

    private void renderRequirementsHistoriesSection() {
        if (this.requirementsHistories.isEmpty()) {
            return;
        }
        this.startSection(this.getI18nString("systemrequirements.history"));
        this.paragraph(this.getI18nString("systemrequirements.history.intro"));
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("systemrequirements.history.version"), this.getI18nString("systemrequirements.history.maven"), this.getI18nString("systemrequirements.history.jdk")});
        ArrayList requirementsVersions = new ArrayList();
        this.requirementsHistories.forEach(requirementsHistory -> {
            ArrayList<RequirementsHistory> current;
            ArrayList<RequirementsHistory> arrayList = current = requirementsVersions.isEmpty() ? null : (ArrayList<RequirementsHistory>)requirementsVersions.get(requirementsVersions.size() - 1);
            if (current != null && ((RequirementsHistory)current.get(0)).hasSameRequirements((RequirementsHistory)requirementsHistory)) {
                current.add((RequirementsHistory)requirementsHistory);
            } else {
                current = new ArrayList<RequirementsHistory>();
                current.add((RequirementsHistory)requirementsHistory);
                requirementsVersions.add(current);
            }
        });
        requirementsVersions.forEach(requirementsHistories -> {
            this.sink.tableRow();
            RequirementsHistory current = (RequirementsHistory)requirementsHistories.get(0);
            if (requirementsHistories.size() == 1) {
                this.tableCell(current.getVersion());
            } else {
                RequirementsHistory from = (RequirementsHistory)requirementsHistories.get(requirementsHistories.size() - 1);
                this.tableCell("from " + from.getVersion() + " to " + current.getVersion());
            }
            this.tableCell(current.getMaven());
            this.tableCell(current.getJdk());
            this.sink.tableRow_();
        });
        this.endTable();
        this.endSection();
    }

    private void renderUsageSection(boolean hasMavenReport) {
        this.startSection(this.getI18nString("usage"));
        this.paragraph(this.getI18nString("usage.intro"));
        StringBuilder sb = new StringBuilder();
        sb.append("<project>").append(Markup.EOL);
        sb.append("  ...").append(Markup.EOL);
        sb.append("  <build>").append(Markup.EOL);
        sb.append("    <!-- " + this.getI18nString("usage.pluginManagement") + " -->").append(Markup.EOL);
        sb.append("    <pluginManagement>").append(Markup.EOL);
        sb.append("      <plugins>").append(Markup.EOL);
        sb.append("        <plugin>").append(Markup.EOL);
        sb.append("          <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
        sb.append("          <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
        sb.append("          <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append(Markup.EOL);
        if (this.hasExtensionsToLoad) {
            sb.append("          <extensions>true</extensions>").append(Markup.EOL);
        }
        sb.append("        </plugin>").append(Markup.EOL);
        sb.append("        ...").append(Markup.EOL);
        sb.append("      </plugins>").append(Markup.EOL);
        sb.append("    </pluginManagement>").append(Markup.EOL);
        sb.append("    <!-- " + this.getI18nString("usage.plugins") + " -->").append(Markup.EOL);
        sb.append("    <plugins>").append(Markup.EOL);
        sb.append("      <plugin>").append(Markup.EOL);
        sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
        sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
        sb.append("      </plugin>").append(Markup.EOL);
        sb.append("      ...").append(Markup.EOL);
        sb.append("    </plugins>").append(Markup.EOL);
        sb.append("  </build>").append(Markup.EOL);
        if (hasMavenReport) {
            sb.append("  ...").append(Markup.EOL);
            sb.append("  <!-- " + this.getI18nString("usage.reporting") + " -->").append(Markup.EOL);
            sb.append("  <reporting>").append(Markup.EOL);
            sb.append("    <plugins>").append(Markup.EOL);
            sb.append("      <plugin>").append(Markup.EOL);
            sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
            sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
            sb.append("        <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append(Markup.EOL);
            sb.append("      </plugin>").append(Markup.EOL);
            sb.append("      ...").append(Markup.EOL);
            sb.append("    </plugins>").append(Markup.EOL);
            sb.append("  </reporting>").append(Markup.EOL);
        }
        sb.append("  ...").append(Markup.EOL);
        sb.append("</project>");
        this.verbatimSource(sb.toString());
        this.sink.paragraph();
        this.linkPatternedText(this.getI18nString("configuration.end"));
        this.sink.paragraph_();
        this.endSection();
    }

    @Override
    protected String getI18nSection() {
        return "plugin";
    }
}

