/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.plugin.descriptor;

import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.tools.plugin.EnhancedParameterWrapper;
import org.apache.maven.tools.plugin.ExtendedPluginDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class EnhancedPluginDescriptorBuilder
extends PluginDescriptorBuilder {
    private final boolean requireAddingMissingParameterSinceField;
    private PlexusConfiguration configuration;

    public EnhancedPluginDescriptorBuilder(RuntimeInformation rtInfo) {
        this(rtInfo.isMavenVersion("[,3.3.9]"));
    }

    EnhancedPluginDescriptorBuilder(boolean requireAddingMissingParameterSinceField) {
        this.requireAddingMissingParameterSinceField = requireAddingMissingParameterSinceField;
    }

    public PlexusConfiguration buildConfiguration(Reader reader) throws PlexusConfigurationException {
        this.configuration = super.buildConfiguration(reader);
        return this.configuration;
    }

    public PluginDescriptor build(Reader reader, String source) throws PlexusConfigurationException {
        PluginDescriptor pluginDescriptor = super.build(reader, source);
        ExtendedPluginDescriptor extendedPluginDescriptor = new ExtendedPluginDescriptor(pluginDescriptor);
        extendedPluginDescriptor.setRequiredJavaVersion(this.configuration.getChild("requiredJavaVersion").getValue());
        extendedPluginDescriptor.setRequiredMavenVersion(this.configuration.getChild("requiredMavenVersion").getValue());
        return extendedPluginDescriptor;
    }

    public MojoDescriptor buildComponentDescriptor(PlexusConfiguration c, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        MojoDescriptor mojoDescriptor = super.buildComponentDescriptor(c, pluginDescriptor);
        PlexusConfiguration[] parameterConfigurations = c.getChild("parameters").getChildren("parameter");
        ArrayList<EnhancedParameterWrapper> parameters = new ArrayList<EnhancedParameterWrapper>(Optional.ofNullable(mojoDescriptor.getParameters()).orElseGet(Collections::emptyList));
        LinkedHashMap<String, EnhancedParameterWrapper> parameterMap = new LinkedHashMap<String, EnhancedParameterWrapper>(mojoDescriptor.getParameterMap());
        for (PlexusConfiguration d : parameterConfigurations) {
            PlexusConfiguration configTypeJavadocUrl;
            String parameterName = d.getChild("name").getValue();
            Parameter pd = (Parameter)parameterMap.get(parameterName);
            if (this.requireAddingMissingParameterSinceField) {
                this.addMissingParameterSinceField(pd, d);
            }
            if ((configTypeJavadocUrl = d.getChild("typeJavadocUrl", false)) == null) continue;
            String parameterTypeJavadocUrl = configTypeJavadocUrl.getValue();
            EnhancedParameterWrapper enhancedParameter = new EnhancedParameterWrapper(pd);
            enhancedParameter.setTypeJavadocUrl(URI.create(parameterTypeJavadocUrl));
            parameters.set(mojoDescriptor.getParameters().indexOf(pd), enhancedParameter);
            parameterMap.put(parameterName, enhancedParameter);
        }
        if (mojoDescriptor.getParameters() != null) {
            mojoDescriptor.getParameters().clear();
        }
        mojoDescriptor.setParameters(parameters);
        mojoDescriptor.getParameterMap().putAll(parameterMap);
        return mojoDescriptor;
    }

    void addMissingParameterSinceField(Parameter pd, PlexusConfiguration d) throws PlexusConfigurationException {
        String parameterSince = d.getChild("since").getValue();
        pd.setSince(parameterSince);
    }
}

