/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.report.GoalRenderer;
import org.apache.maven.plugin.plugin.report.PluginOverviewRenderer;
import org.apache.maven.plugin.plugin.report.RequirementsHistory;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.plugin.descriptor.EnhancedPluginDescriptorBuilder;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Mojo(name="report", threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class PluginReport
extends AbstractMavenReport {
    @Parameter(defaultValue="false", property="maven.plugin.report.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="maven.plugin.report.hasExtensionsToLoad")
    private boolean hasExtensionsToLoad;
    @Parameter
    private List<RequirementsHistory> requirementsHistories = new ArrayList<RequirementsHistory>();
    @Parameter(defaultValue="[0,)")
    private String requirementsHistoryDetectionRange;
    @Component
    private RuntimeInformation rtInfo;
    @Component
    private I18N i18n;
    @Parameter(defaultValue="${project.build.directory}/plugin-enhanced.xml", required=true, readonly=true)
    private File enhancedPluginXmlFile;
    @Parameter(property="maven.plugin.report.disableInternalJavadocLinkValidation")
    private boolean disableInternalJavadocLinkValidation;
    @Component
    private MavenSession mavenSession;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProjectBuilder projectBuilder;

    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Maven Plugin Plugin Report generation skipped.");
            return false;
        }
        return this.enhancedPluginXmlFile != null && this.enhancedPluginXmlFile.isFile() && this.enhancedPluginXmlFile.canRead();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        PluginDescriptor pluginDescriptor = this.extractPluginDescriptor();
        this.generateMojosDocumentation(pluginDescriptor, locale);
        if (this.requirementsHistories.isEmpty()) {
            String v = null;
            try {
                List<Version> versions = this.discoverVersions(this.requirementsHistoryDetectionRange);
                if (versions.isEmpty()) {
                    this.getLog().info((CharSequence)("No plugin history found for range " + this.requirementsHistoryDetectionRange));
                } else {
                    this.getLog().info((CharSequence)("Detecting plugin requirements history for range " + this.requirementsHistoryDetectionRange + ": " + versions.size() + " releases, from " + versions.get(0) + " to " + versions.get(versions.size() - 1)));
                }
                Collections.reverse(versions);
                for (Version version : versions) {
                    v = version.toString();
                    MavenProject versionProject = this.buildMavenProject(v);
                    RequirementsHistory requirements = RequirementsHistory.discoverRequirements(versionProject);
                    this.requirementsHistories.add(requirements);
                    this.getLog().info((CharSequence)("  - " + requirements));
                }
            }
            catch (VersionRangeResolutionException vrre) {
                throw new MavenReportException("Cannot resolve past versions " + this.requirementsHistoryDetectionRange, (Exception)((Object)vrre));
            }
            catch (ProjectBuildingException pbe) {
                throw new MavenReportException("Cannot resolve MavenProject for version " + v, (Exception)((Object)pbe));
            }
        }
        PluginOverviewRenderer r = new PluginOverviewRenderer(this.getSink(), this.i18n, locale, this.getProject(), this.requirementsHistories, pluginDescriptor, this.hasExtensionsToLoad);
        r.render();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginDescriptor extractPluginDescriptor() throws MavenReportException {
        EnhancedPluginDescriptorBuilder builder = new EnhancedPluginDescriptorBuilder(this.rtInfo);
        try (XmlStreamReader input = new XmlStreamReader(Files.newInputStream(this.enhancedPluginXmlFile.toPath(), new OpenOption[0]));){
            PluginDescriptor pluginDescriptor = builder.build((Reader)input);
            return pluginDescriptor;
        }
        catch (IOException | PlexusConfigurationException e) {
            throw new MavenReportException("Error extracting plugin descriptor from " + this.enhancedPluginXmlFile, (Exception)e);
        }
    }

    private String getI18nString(Locale locale, String key) {
        return this.i18n.getString("plugin-report", locale, "report.plugin." + key);
    }

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    public String getOutputName() {
        return "plugin-info";
    }

    private void generateMojosDocumentation(PluginDescriptor pluginDescriptor, Locale locale) throws MavenReportException {
        if (pluginDescriptor.getMojos() != null) {
            for (MojoDescriptor descriptor : pluginDescriptor.getMojos()) {
                GoalRenderer renderer;
                try {
                    String filename = descriptor.getGoal() + "-mojo.html";
                    Sink sink = this.getSinkFactory().createSink(this.getReportOutputDirectory(), filename);
                    renderer = new GoalRenderer(sink, this.i18n, locale, this.project, descriptor, this.getReportOutputDirectory(), this.disableInternalJavadocLinkValidation, this.getLog());
                }
                catch (IOException e) {
                    throw new MavenReportException("Cannot generate sink for mojo " + descriptor.getGoal(), (Exception)e);
                }
                renderer.render();
            }
        }
    }

    private List<Version> discoverVersions(String range) throws VersionRangeResolutionException {
        MavenProject currentProject = this.mavenSession.getCurrentProject();
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)new DefaultArtifact(currentProject.getGroupId() + ":" + currentProject.getArtifactId() + ":" + range));
        rangeRequest.setRepositories(RepositoryUtils.toRepos((List)this.mavenSession.getCurrentProject().getRemoteArtifactRepositories()));
        VersionRangeResult rangeResult = this.repositorySystem.resolveVersionRange(this.mavenSession.getRepositorySession(), rangeRequest);
        return rangeResult.getVersions().stream().filter(version -> !ArtifactUtils.isSnapshot((String)version.toString())).collect(Collectors.toList());
    }

    private MavenProject buildMavenProject(String version) throws ProjectBuildingException {
        MavenProject currentProject = this.mavenSession.getCurrentProject();
        DefaultProjectBuildingRequest buildRequest = new DefaultProjectBuildingRequest();
        buildRequest.setLocalRepository(this.mavenSession.getLocalRepository());
        buildRequest.setRemoteRepositories(this.mavenSession.getCurrentProject().getRemoteArtifactRepositories());
        buildRequest.setValidationLevel(0);
        buildRequest.setProcessPlugins(false);
        buildRequest.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
        buildRequest.setSystemProperties(this.mavenSession.getSystemProperties());
        buildRequest.setUserProperties(this.mavenSession.getUserProperties());
        buildRequest.setRepositorySession(this.mavenSession.getRepositorySession());
        return this.projectBuilder.build(RepositoryUtils.toArtifact((Artifact)new DefaultArtifact(currentProject.getGroupId() + ":" + currentProject.getArtifactId() + ":pom:" + version)), (ProjectBuildingRequest)buildRequest).getProject();
    }
}

