/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.markup.Markup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.report.AbstractPluginReportRenderer;
import org.apache.maven.plugin.plugin.report.RequirementsHistory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.ExtendedPluginDescriptor;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class PluginOverviewRenderer
extends AbstractPluginReportRenderer {
    private final List<RequirementsHistory> requirementsHistories;
    private final PluginDescriptor pluginDescriptor;
    private final boolean hasExtensionsToLoad;

    PluginOverviewRenderer(Sink sink, I18N i18n, Locale locale, MavenProject project, List<RequirementsHistory> requirementsHistories, PluginDescriptor pluginDescriptor, boolean hasExtensionsToLoad) {
        super(sink, locale, i18n, project);
        this.requirementsHistories = requirementsHistories;
        this.pluginDescriptor = pluginDescriptor;
        this.hasExtensionsToLoad = hasExtensionsToLoad;
    }

    protected void renderBody() {
        this.startSection(this.getTitle());
        if (this.pluginDescriptor.getMojos() == null || this.pluginDescriptor.getMojos().size() <= 0) {
            this.paragraph(this.getI18nString("goals.nogoal"));
            this.endSection();
            return;
        }
        this.paragraph(this.getI18nString("goals.intro"));
        boolean hasMavenReport = false;
        for (MojoDescriptor mojo : this.pluginDescriptor.getMojos()) {
            if (!PluginUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) continue;
            hasMavenReport = true;
        }
        this.startTable();
        String goalColumnName = this.getI18nString("goals.column.goal");
        String isMavenReport = this.getI18nString("goals.column.isMavenReport");
        String descriptionColumnName = this.getI18nString("goals.column.description");
        if (hasMavenReport) {
            this.tableHeader(new String[]{goalColumnName, isMavenReport, descriptionColumnName});
        } else {
            this.tableHeader(new String[]{goalColumnName, descriptionColumnName});
        }
        ArrayList mojos = new ArrayList();
        mojos.addAll(this.pluginDescriptor.getMojos());
        PluginUtils.sortMojos(mojos);
        for (MojoDescriptor mojo : mojos) {
            this.sink.tableRow();
            String goalName = mojo.getFullGoalName();
            String goalDocumentationLink = "./" + mojo.getGoal() + "-mojo.html";
            this.sink.tableCell();
            this.link(goalDocumentationLink, goalName);
            this.sink.tableCell_();
            if (hasMavenReport) {
                if (PluginUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) {
                    this.tableCell(this.getI18nString("isReport"));
                } else {
                    this.tableCell(this.getI18nString("isNotReport"));
                }
            }
            String description = StringUtils.isNotEmpty((CharSequence)mojo.getDeprecated()) ? "<strong>" + this.getI18nString("goal.deprecated") + "</strong> " + mojo.getDeprecated() : (StringUtils.isNotEmpty((CharSequence)mojo.getDescription()) ? mojo.getDescription() : this.getI18nString("goal.nodescription"));
            this.tableCell(description, true);
            this.sink.tableRow_();
        }
        this.endTable();
        this.startSection(this.getI18nString("systemrequirements"));
        this.paragraph(this.getI18nString("systemrequirements.intro"));
        this.startTable();
        String maven = PluginOverviewRenderer.discoverMavenRequirement(this.project, this.pluginDescriptor);
        this.sink.tableRow();
        this.tableCell(this.getI18nString("systemrequirements.maven"));
        this.tableCell(maven != null ? maven : this.getI18nString("systemrequirements.nominimum"));
        this.sink.tableRow_();
        String jdk = PluginOverviewRenderer.discoverJdkRequirement(this.project, this.pluginDescriptor);
        this.sink.tableRow();
        this.tableCell(this.getI18nString("systemrequirements.jdk"));
        this.tableCell(jdk != null ? jdk : this.getI18nString("systemrequirements.nominimum"));
        this.sink.tableRow_();
        this.endTable();
        this.endSection();
        this.renderRequirementsHistories();
        this.renderUsageSection(hasMavenReport);
        this.endSection();
    }

    private void renderRequirementsHistories() {
        if (this.requirementsHistories.isEmpty()) {
            return;
        }
        this.startSection(this.getI18nString("systemrequirements.history"));
        this.paragraph(this.getI18nString("systemrequirements.history.intro"));
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("systemrequirements.history.version"), this.getI18nString("systemrequirements.history.maven"), this.getI18nString("systemrequirements.history.jdk")});
        this.requirementsHistories.forEach(requirementsHistory -> {
            this.sink.tableRow();
            this.tableCell(requirementsHistory.getVersion());
            this.tableCell(requirementsHistory.getMaven());
            this.tableCell(requirementsHistory.getJdk());
            this.sink.tableRow_();
        });
        this.endTable();
        this.endSection();
    }

    private void renderUsageSection(boolean hasMavenReport) {
        this.startSection(this.getI18nString("usage"));
        this.paragraph(this.getI18nString("usage.intro"));
        StringBuilder sb = new StringBuilder();
        sb.append("<project>").append(Markup.EOL);
        sb.append("  ...").append(Markup.EOL);
        sb.append("  <build>").append(Markup.EOL);
        sb.append("    <!-- " + this.getI18nString("usage.pluginManagement") + " -->").append(Markup.EOL);
        sb.append("    <pluginManagement>").append(Markup.EOL);
        sb.append("      <plugins>").append(Markup.EOL);
        sb.append("        <plugin>").append(Markup.EOL);
        sb.append("          <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
        sb.append("          <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
        sb.append("          <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append(Markup.EOL);
        if (this.hasExtensionsToLoad) {
            sb.append("          <extensions>true</extensions>").append(Markup.EOL);
        }
        sb.append("        </plugin>").append(Markup.EOL);
        sb.append("        ...").append(Markup.EOL);
        sb.append("      </plugins>").append(Markup.EOL);
        sb.append("    </pluginManagement>").append(Markup.EOL);
        sb.append("    <!-- " + this.getI18nString("usage.plugins") + " -->").append(Markup.EOL);
        sb.append("    <plugins>").append(Markup.EOL);
        sb.append("      <plugin>").append(Markup.EOL);
        sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
        sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
        sb.append("      </plugin>").append(Markup.EOL);
        sb.append("      ...").append(Markup.EOL);
        sb.append("    </plugins>").append(Markup.EOL);
        sb.append("  </build>").append(Markup.EOL);
        if (hasMavenReport) {
            sb.append("  ...").append(Markup.EOL);
            sb.append("  <!-- " + this.getI18nString("usage.reporting") + " -->").append(Markup.EOL);
            sb.append("  <reporting>").append(Markup.EOL);
            sb.append("    <plugins>").append(Markup.EOL);
            sb.append("      <plugin>").append(Markup.EOL);
            sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append(Markup.EOL);
            sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append(Markup.EOL);
            sb.append("        <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append(Markup.EOL);
            sb.append("      </plugin>").append(Markup.EOL);
            sb.append("      ...").append(Markup.EOL);
            sb.append("    </plugins>").append(Markup.EOL);
            sb.append("  </reporting>").append(Markup.EOL);
        }
        sb.append("  ...").append(Markup.EOL);
        sb.append("</project>");
        this.verbatimText(sb.toString());
        this.sink.paragraph();
        this.linkPatternedText(this.getI18nString("configuration.end"));
        this.sink.paragraph_();
        this.endSection();
    }

    private static String discoverMavenRequirement(MavenProject project, PluginDescriptor pluginDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)pluginDescriptor.getRequiredMavenVersion())) {
            return pluginDescriptor.getRequiredMavenVersion();
        }
        return Optional.ofNullable(project.getPrerequisites()).map(Prerequisites::getMaven).orElse(null);
    }

    private static String discoverJdkRequirement(MavenProject project, PluginDescriptor pluginDescriptor) {
        String version;
        String jdk = null;
        if (pluginDescriptor instanceof ExtendedPluginDescriptor) {
            ExtendedPluginDescriptor extPluginDescriptor = (ExtendedPluginDescriptor)pluginDescriptor;
            jdk = extPluginDescriptor.getRequiredJavaVersion();
        }
        if (jdk != null) {
            return jdk;
        }
        Plugin compiler = PluginOverviewRenderer.getCompilerPlugin(project.getBuild().getPluginsAsMap());
        if (compiler == null) {
            compiler = PluginOverviewRenderer.getCompilerPlugin(project.getPluginManagement().getPluginsAsMap());
        }
        if ((jdk = PluginOverviewRenderer.getPluginParameter(compiler, "release")) != null) {
            return jdk;
        }
        jdk = project.getProperties().getProperty("maven.compiler.release");
        if (jdk != null) {
            return jdk;
        }
        jdk = PluginOverviewRenderer.getPluginParameter(compiler, "target");
        if (jdk != null) {
            return jdk;
        }
        jdk = project.getProperties().getProperty("maven.compiler.target");
        if (jdk != null) {
            return jdk;
        }
        String string = version = compiler == null ? null : compiler.getVersion();
        if (version != null) {
            return "Default target for maven-compiler-plugin version " + version;
        }
        return null;
    }

    private static Plugin getCompilerPlugin(Map<String, Plugin> pluginsAsMap) {
        return pluginsAsMap.get("org.apache.maven.plugins:maven-compiler-plugin");
    }

    private static String getPluginParameter(Plugin plugin, String parameter) {
        Xpp3Dom target;
        Xpp3Dom pluginConf;
        if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
            return target.getValue();
        }
        return null;
    }

    @Override
    protected String getI18nSection() {
        return "plugin";
    }
}

