/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.AbstractJavadocMojo;
import org.apache.maven.plugins.javadoc.resolver.ResourceResolver;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="resource-bundle", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ResourcesBundleMojo
extends AbstractJavadocMojo {
    public static final String BUNDLE_OPTIONS_PATH = "META-INF/maven/javadoc-options.xml";
    public static final String RESOURCES_DIR_PATH = "resources";
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    private MavenProjectHelper projectHelper;
    private ArchiverManager archiverManager;

    @Inject
    public ResourcesBundleMojo(MavenProjectHelper projectHelper, SiteTool siteTool, ArchiverManager archiverManager, ResourceResolver resourceResolver, RepositorySystem repoSystem, ArtifactHandlerManager artifactHandlerManager, ProjectBuilder mavenProjectBuilder, ToolchainManager toolchainManager) {
        super(siteTool, archiverManager, resourceResolver, repoSystem, artifactHandlerManager, mavenProjectBuilder, toolchainManager);
        this.archiverManager = archiverManager;
        this.projectHelper = projectHelper;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Archiver archiver;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc resource bundle generation");
            return;
        }
        try {
            this.buildJavadocOptions();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate javadoc-options file: " + e.getMessage(), (Exception)e);
        }
        try {
            archiver = this.archiverManager.getArchiver("jar");
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Failed to retrieve jar archiver component from manager.", (Exception)((Object)e));
        }
        File optionsFile = this.getJavadocOptionsFile();
        File bundleFile = new File(this.getProject().getBuild().getDirectory(), this.finalName + "-" + this.getAttachmentClassifier() + ".jar");
        try {
            archiver.addFile(optionsFile, BUNDLE_OPTIONS_PATH);
            File javadocDir = this.getJavadocDirectory();
            if (javadocDir.isDirectory()) {
                DefaultFileSet fileSet = (DefaultFileSet)DefaultFileSet.fileSet((File)javadocDir).prefixed("resources/");
                archiver.addFileSet((FileSet)fileSet);
            }
            archiver.setDestFile(bundleFile);
            archiver.createArchive();
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Failed to assemble javadoc-resources bundle archive. Reason: " + e.getMessage(), (Exception)e);
        }
        this.projectHelper.attachArtifact(this.getProject(), bundleFile, this.getAttachmentClassifier());
    }
}

