/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jar;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
class ToolchainsJdkSpecification {
    private final Logger logger = LoggerFactory.getLogger(ToolchainsJdkSpecification.class);
    private final Map<Path, String> cache = new HashMap<Path, String>();

    ToolchainsJdkSpecification() {
    }

    public synchronized Optional<String> getJDKSpecification(Toolchain toolchain) {
        Optional<Path> javacPath = this.getJavacPath(toolchain);
        return javacPath.map(path -> this.cache.computeIfAbsent((Path)path, this::getSpecForPath));
    }

    private Optional<Path> getJavacPath(Toolchain toolchain) {
        return Optional.ofNullable(toolchain.findTool("javac")).map(x$0 -> Paths.get(x$0, new String[0])).map(this::getCanonicalPath);
    }

    private Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            if (path.getParent() != null) {
                return this.getCanonicalPath(path.getParent()).resolve(path.getFileName());
            }
            throw new UncheckedIOException(e);
        }
    }

    private String getSpecForPath(Path path) {
        try {
            Commandline cl = new Commandline(path.toString());
            cl.createArg().setValue("-version");
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
            String version = out.getOutput().trim();
            if (version.isEmpty()) {
                version = err.getOutput().trim();
            }
            if (version.startsWith("javac ")) {
                version = (version = version.substring(6)).startsWith("1.") ? version.substring(0, 3) : version.substring(0, 2);
                return version;
            }
            this.logger.warn("Unrecognized output form " + path + " -version - " + version);
            return null;
        }
        catch (IndexOutOfBoundsException | CommandLineException e) {
            this.logger.warn("Failed to execute: " + path + " - " + e.getMessage());
            return null;
        }
    }
}

