/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-jar-plugin:2.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven JAR Plugin", 0);
        this.append(sb, "Builds a Java Archive (JAR) file from the compiled project classes and resources.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jar:help", 0);
            this.append(sb, "Display help information on maven-jar-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jar:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jar".equals(this.goal)) {
            this.append(sb, "jar:jar", 0);
            this.append(sb, "Build a JAR from the current project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "Directory containing the classes and resource files that should be packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to add to the artifact generated. If given, the artifact will be an attachment instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "Name of the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory containing the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sign".equals(this.goal)) {
            this.append(sb, "jar:sign", 0);
            this.append(sb, "Deprecated. As of version 2.3, this goal is no longer supported in favor of the dedicated maven-jarsigner-plugin.", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Signs a JAR using jarsigner.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "alias", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classifier", 2);
                this.append(sb, "Classifier to use for the generated artifact. If not specified, the generated artifact becomes the primary artifact.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "Name of the generated JAR (without classifier and extension).", 3);
                this.append(sb, "", 0);
                this.append(sb, "jarPath (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2);
                this.append(sb, "Path of the jar to sign. When specified, the finalName is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keypass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sigfile", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "signedjar", 2);
                this.append(sb, "See options.\n>Not specifying this argument will sign the jar in-place (your original jar is going to be overwritten).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to true to disable signing. Useful to speed up build process in development environment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "storepass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "type", 2);
                this.append(sb, "See options. The corresponding option in the command line is -storetype.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose. See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verify (Default: false)", 2);
                this.append(sb, "Automatically verify a jar after signing it.\n>See options.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "The working directory in which the jarsigner executable will be run.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sign-verify".equals(this.goal)) {
            this.append(sb, "jar:sign-verify", 0);
            this.append(sb, "Deprecated. As of version 2.3, this goal is no longer supported in favor of the dedicated maven-jarsigner-plugin.", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Checks the signature of a signed jar using jarsigner.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "checkCerts (Default: false)", 2);
                this.append(sb, "Check certificates. Requires setVerbose(). See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "errorWhenNotSigned (Default: true)", 2);
                this.append(sb, "When true this will make the execute() operation fail, throwing an exception, when verifying a non signed jar. Primarily to keep backwards compatibility with existing code, and allow reusing the bean in unattended operations when set to false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "Name of the generated JAR (without classifier and extension).", 3);
                this.append(sb, "", 0);
                this.append(sb, "jarPath", 2);
                this.append(sb, "Path of the signed jar. When specified, the finalName is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose See options.", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "The working directory in which the jarsigner executable will be run.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-jar".equals(this.goal)) {
            this.append(sb, "jar:test-jar", 0);
            this.append(sb, "Build a JAR of the test classes for the current project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "Name of the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceCreation (Default: false)", 2);
                this.append(sb, "Whether creating the archive should be forced.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory containing the generated JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "Set this to true to bypass unit tests entirely. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory", 2);
                this.append(sb, "Directory containing the test classes and resource files that should be packaged into the JAR.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultManifestFile (Default: false)", 2);
                this.append(sb, "Set this to true to enable the use of the defaultManifestFile.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

