/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="active-profiles", aggregator=true)
public class ActiveProfilesMojo
extends AbstractHelpMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;

    @Inject
    public ActiveProfilesMojo(ProjectBuilder projectBuilder, RepositorySystem repositorySystem) {
        super(projectBuilder, repositorySystem);
    }

    public void execute() throws MojoExecutionException {
        StringBuilder message = new StringBuilder();
        for (MavenProject project : this.projects) {
            this.getActiveProfileStatement(project, message);
            message.append(LS).append(LS);
        }
        if (this.output != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated by Maven Help Plugin").append(LS);
            sb.append("See: https://maven.apache.org/plugins/maven-help-plugin/").append(LS).append(LS);
            sb.append(message.toString());
            try {
                ActiveProfilesMojo.writeFile(this.output, sb);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write active profiles to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Active profile report written to: " + this.output));
        } else {
            this.getLog().info((CharSequence)message);
        }
    }

    private void getActiveProfileStatement(MavenProject project, StringBuilder message) {
        Map activeProfileIds = project.getInjectedProfileIds();
        message.append(LS);
        message.append("Active Profiles for Project '").append(project.getId()).append("':");
        message.append(LS).append(LS);
        if (activeProfileIds.isEmpty()) {
            message.append("There are no active profiles.");
        } else {
            message.append("The following profiles are active:").append(LS);
            for (Map.Entry entry : activeProfileIds.entrySet()) {
                for (String profileId : (List)entry.getValue()) {
                    message.append(LS).append(" - ").append(profileId);
                    message.append(" (source: ").append((String)entry.getKey()).append(")");
                }
            }
        }
        message.append(LS);
    }
}

