/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.GpgVersion;
import org.apache.maven.plugins.gpg.GpgVersionParser;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GpgSigner
extends AbstractGpgSigner {
    public static final String NAME = "gpg";
    private final String executable;

    public GpgSigner(String executable) {
        this.executable = executable;
    }

    @Override
    public String signerName() {
        return NAME;
    }

    @Override
    public String getKeyInfo() {
        return this.keyname != null ? this.keyname : "default";
    }

    @Override
    protected void generateSignatureForFile(File file, File signature) throws MojoExecutionException {
        Commandline cmd = new Commandline();
        if (this.executable != null && !this.executable.isEmpty()) {
            cmd.setExecutable(this.executable);
        } else {
            cmd.setExecutable(NAME + (Os.isFamily((String)"windows") ? ".exe" : ""));
        }
        GpgVersionParser versionParser = GpgVersionParser.parse(this.executable);
        GpgVersion gpgVersion = versionParser.getGpgVersion();
        if (gpgVersion == null) {
            throw new MojoExecutionException("Could not determine gpg version");
        }
        this.getLog().debug((CharSequence)gpgVersion.toString());
        if (this.args != null) {
            for (String arg : this.args) {
                cmd.createArg().setValue(arg);
            }
        }
        if (this.homeDir != null) {
            cmd.createArg().setValue("--homedir");
            cmd.createArg().setFile(this.homeDir);
        }
        if (gpgVersion.isBefore(GpgVersion.parse("2.1"))) {
            if (this.useAgent) {
                cmd.createArg().setValue("--use-agent");
            } else {
                cmd.createArg().setValue("--no-use-agent");
            }
        }
        ByteArrayInputStream in = null;
        if (null != this.passphrase) {
            if (gpgVersion.isAtLeast(GpgVersion.parse("2.0"))) {
                cmd.createArg().setValue("--batch");
            }
            if (gpgVersion.isAtLeast(GpgVersion.parse("2.1"))) {
                cmd.createArg().setValue("--pinentry-mode");
                cmd.createArg().setValue("loopback");
            }
            cmd.createArg().setValue("--passphrase-fd");
            cmd.createArg().setValue("0");
            in = !this.passphrase.endsWith(System.lineSeparator()) ? new ByteArrayInputStream((this.passphrase + System.lineSeparator()).getBytes()) : new ByteArrayInputStream(this.passphrase.getBytes());
        }
        if (null != this.keyname) {
            cmd.createArg().setValue("--local-user");
            cmd.createArg().setValue(this.keyname);
        }
        cmd.createArg().setValue("--armor");
        cmd.createArg().setValue("--detach-sign");
        if (this.getLog().isDebugEnabled()) {
            cmd.createArg().setValue("--status-fd");
            cmd.createArg().setValue("1");
        }
        if (!this.isInteractive) {
            cmd.createArg().setValue("--batch");
            cmd.createArg().setValue("--no-tty");
            if (null == this.passphrase && gpgVersion.isAtLeast(GpgVersion.parse("2.1"))) {
                cmd.createArg().setValue("--pinentry-mode");
                cmd.createArg().setValue("error");
            }
        }
        if (!this.defaultKeyring) {
            cmd.createArg().setValue("--no-default-keyring");
        }
        if (this.secretKeyring != null && !this.secretKeyring.isEmpty()) {
            if (gpgVersion.isBefore(GpgVersion.parse("2.1"))) {
                cmd.createArg().setValue("--secret-keyring");
                cmd.createArg().setValue(this.secretKeyring);
            } else {
                this.getLog().warn((CharSequence)"'secretKeyring' is an obsolete option and ignored. All secret keys are stored in the \u2018private-keys-v1.d\u2019 directory below the GnuPG home directory.");
            }
        }
        if (this.publicKeyring != null && !this.publicKeyring.isEmpty()) {
            cmd.createArg().setValue("--keyring");
            cmd.createArg().setValue(this.publicKeyring);
        }
        if ("once".equalsIgnoreCase(this.lockMode)) {
            cmd.createArg().setValue("--lock-once");
        } else if ("multiple".equalsIgnoreCase(this.lockMode)) {
            cmd.createArg().setValue("--lock-multiple");
        } else if ("never".equalsIgnoreCase(this.lockMode)) {
            cmd.createArg().setValue("--lock-never");
        }
        cmd.createArg().setValue("--output");
        cmd.createArg().setFile(signature);
        cmd.createArg().setFile(file);
        this.getLog().debug((CharSequence)("CMD: " + cmd));
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (InputStream)in, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
            if (exitCode != 0) {
                throw new MojoExecutionException("Exit code: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute gpg command", (Exception)((Object)e));
        }
    }
}

