/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromDependencies.AbstractDependencyFilterMojo;
import org.apache.maven.plugins.dependency.resolvers.ExcludeReactorProjectsArtifactFilter;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;

public abstract class AbstractResolveMojo
extends AbstractDependencyFilterMojo {
    @Parameter(property="outputFile")
    protected File outputFile;
    @Parameter(property="appendOutput", defaultValue="false")
    protected boolean appendOutput;
    @Parameter(property="excludeReactor", defaultValue="true")
    protected boolean excludeReactor;
    @Parameter
    protected boolean ignorePermissions;

    protected FilterArtifacts getArtifactsFilter() {
        FilterArtifacts filter = new FilterArtifacts();
        if (this.excludeReactor) {
            filter.addFilter((ArtifactsFilter)new ExcludeReactorProjectsArtifactFilter(this.reactorProjects, this.getLog()));
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeScope), DependencyUtil.cleanToBeTokenizedString(this.excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(DependencyUtil.cleanToBeTokenizedString(this.includeTypes), DependencyUtil.cleanToBeTokenizedString(this.excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(DependencyUtil.cleanToBeTokenizedString(this.includeClassifiers), DependencyUtil.cleanToBeTokenizedString(this.excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeGroupIds), DependencyUtil.cleanToBeTokenizedString(this.excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(DependencyUtil.cleanToBeTokenizedString(this.includeArtifactIds), DependencyUtil.cleanToBeTokenizedString(this.excludeArtifactIds)));
        return filter;
    }

    protected Set<Artifact> resolveArtifactDependencies(DependableCoordinate artifact) throws DependencyResolverException {
        ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
        Iterable artifactResults = this.getDependencyResolver().resolveDependencies(buildingRequest, artifact, null);
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (ArtifactResult artifactResult : artifactResults) {
            artifacts.add(artifactResult.getArtifact());
        }
        return artifacts;
    }
}

