/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;

@Mojo(name="list-repositories", threadSafe=true)
public class ListRepositoriesMojo
extends AbstractDependencyMojo {
    @Component
    RepositorySystem repositorySystem;

    @Override
    protected void doExecute() throws MojoExecutionException {
        CollectRequest request = new CollectRequest();
        request.setRepositories(this.getProject().getRemoteProjectRepositories());
        request.setRootArtifact(RepositoryUtils.toArtifact((Artifact)this.getProject().getArtifact()));
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        request.setDependencies(this.getProject().getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()));
        request.setManagedDependencies(Optional.ofNullable(this.getProject().getDependencyManagement()).map(DependencyManagement::getDependencies).orElseGet(Collections::emptyList).stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList()));
        try {
            CollectResult collectResult = this.repositorySystem.collectDependencies(this.session.getRepositorySession(), request);
            final HashSet repositories = new HashSet();
            collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

                public boolean visitEnter(DependencyNode node) {
                    repositories.addAll(node.getRepositories());
                    return true;
                }

                public boolean visitLeave(DependencyNode node) {
                    return true;
                }
            }));
            StringBuilder message = new StringBuilder();
            Map<Boolean, List<RemoteRepository>> repoGroupByMirrors = repositories.stream().collect(Collectors.groupingBy(repo -> repo.getMirroredRepositories().isEmpty()));
            this.prepareRemoteRepositoriesList(message, (Collection<RemoteRepository>)repoGroupByMirrors.get(Boolean.TRUE));
            this.prepareRemoteMirrorRepositoriesList(message, (Collection<RemoteRepository>)repoGroupByMirrors.get(Boolean.FALSE));
            this.getLog().info((CharSequence)message);
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void prepareRemoteMirrorRepositoriesList(StringBuilder message, Collection<RemoteRepository> remoteProjectRepositories) {
        HashMap<RemoteRepository, RemoteRepository> mirrorMap = new HashMap<RemoteRepository, RemoteRepository>();
        remoteProjectRepositories.forEach(repo -> repo.getMirroredRepositories().forEach(mrepo -> mirrorMap.put((RemoteRepository)mrepo, (RemoteRepository)repo)));
        mirrorMap.forEach((repo, mirror) -> message.append(" * ").append(repo).append(" mirrored by ").append(mirror).append(System.lineSeparator()));
    }

    private void prepareRemoteRepositoriesList(StringBuilder message, Collection<RemoteRepository> remoteProjectRepositories) {
        message.append("Project remote repositories used by this build:").append(System.lineSeparator());
        remoteProjectRepositories.forEach(repo -> message.append(" * ").append(repo).append(System.lineSeparator()));
    }

    private Map<RemoteRepository, RemoteRepository> getMirroredRepo(Set<RemoteRepository> repositories) {
        HashMap<RemoteRepository, RemoteRepository> mirrorMap = new HashMap<RemoteRepository, RemoteRepository>();
        repositories.stream().filter(repo -> !repo.getMirroredRepositories().isEmpty()).forEach(repo -> repo.getMirroredRepositories().forEach(mrepo -> mirrorMap.put((RemoteRepository)mrepo, (RemoteRepository)repo)));
        return mirrorMap;
    }
}

