/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.Node;
import org.apache.maven.shared.artifact.filter.resolve.PatternExclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.PatternInclusionsFilter;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.TransferUtils;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="purge-local-repository", threadSafe=true, requiresProject=false)
public class PurgeLocalRepositoryMojo
extends AbstractMojo {
    private static final String VERSION_FUZZINESS = "version";
    private static final String ARTIFACT_ID_FUZZINESS = "artifactId";
    private static final String GROUP_ID_FUZZINESS = "groupId";
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${mojo}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter
    private List<String> manualIncludes;
    @Parameter(property="manualInclude")
    private String manualInclude;
    @Parameter
    private List<String> includes;
    @Parameter(property="include")
    private String include;
    @Parameter
    private List<String> excludes;
    @Parameter(property="exclude")
    private String exclude;
    @Parameter(property="reResolve", defaultValue="true")
    private boolean reResolve;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(property="resolutionFuzziness", defaultValue="version")
    private String resolutionFuzziness;
    @Parameter(property="actTransitively", defaultValue="true")
    private boolean actTransitively;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="snapshotsOnly", defaultValue="false")
    private boolean snapshotsOnly;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)this.manualInclude)) {
            this.manualIncludes = this.parseIncludes(this.manualInclude);
        }
        if (this.manualIncludes != null && this.manualIncludes.size() > 0) {
            this.manualPurge(this.manualIncludes);
            return;
        }
        HashSet<Artifact> purgedArtifacts = new HashSet<Artifact>();
        if (this.shouldPurgeAllProjectsInReactor()) {
            for (MavenProject reactorProject : this.reactorProjects) {
                this.purgeLocalRepository(reactorProject, purgedArtifacts);
            }
        } else {
            this.purgeLocalRepository(this.project, purgedArtifacts);
        }
    }

    private boolean shouldPurgeAllProjectsInReactor() {
        MojoExecution.Source source = this.mojoExecution.getSource();
        return this.reactorProjects.size() > 1 && source == MojoExecution.Source.CLI;
    }

    private void purgeLocalRepository(MavenProject theProject, Set<Artifact> purgedArtifacts) throws MojoFailureException {
        TransformableFilter dependencyFilter;
        List dependencies = theProject.getDependencies();
        Set<Artifact> resolvedArtifactsToPurge = this.getFilteredResolvedArtifacts(theProject, dependencies, dependencyFilter = this.createPurgeArtifactsFilter(theProject, dependencies, purgedArtifacts));
        if (resolvedArtifactsToPurge.isEmpty()) {
            this.getLog().info((CharSequence)("No artifacts included for purge for project: " + this.getProjectKey(theProject)));
            return;
        }
        this.purgeArtifacts(theProject, resolvedArtifactsToPurge);
        purgedArtifacts.addAll(resolvedArtifactsToPurge);
        if (this.reResolve) {
            this.getLog().info((CharSequence)"Re-resolving dependencies");
            try {
                this.reResolveArtifacts(theProject, resolvedArtifactsToPurge);
            }
            catch (ArtifactResolutionException e) {
                String failureMessage = "Failed to refresh project dependencies for: " + theProject.getId();
                throw new MojoFailureException(failureMessage, (Throwable)e);
            }
        }
    }

    private void manualPurge(List<String> theIncludes) throws MojoExecutionException {
        MessageBuilder messageBuilder = MessageUtils.buffer();
        this.getLog().info((CharSequence)messageBuilder.a((CharSequence)"Deleting ").strong((Object)theIncludes.size()).a((CharSequence)" manual ").a((CharSequence)(theIncludes.size() != 1 ? "dependencies" : "dependency")).a((CharSequence)" from ").strong((Object)this.localRepository.getBasedir()).toString());
        for (String gavPattern : theIncludes) {
            if (StringUtils.isEmpty((CharSequence)gavPattern)) {
                this.getLog().debug((CharSequence)"Skipping empty gav pattern");
                continue;
            }
            String relativePath = this.gavToPath(gavPattern);
            if (StringUtils.isEmpty((CharSequence)relativePath)) {
                this.getLog().debug((CharSequence)("Skipping empty relative path for gav pattern: " + gavPattern));
                continue;
            }
            File purgeDir = new File(this.localRepository.getBasedir(), relativePath);
            if (purgeDir.exists()) {
                this.getLog().debug((CharSequence)("Deleting directory: " + purgeDir));
                try {
                    FileUtils.deleteDirectory((File)purgeDir);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to purge directory: " + purgeDir);
                }
            }
            this.getLog().debug((CharSequence)("Directory: " + purgeDir + " doesn't exist"));
        }
    }

    private String gavToPath(String gav) {
        if (StringUtils.isEmpty((CharSequence)gav)) {
            return null;
        }
        String[] pathComponents = gav.split(":");
        StringBuilder path = new StringBuilder(pathComponents[0].replace('.', '/'));
        for (int i = 1; i < pathComponents.length; ++i) {
            path.append("/").append(pathComponents[i]);
        }
        return path.toString();
    }

    private TransformableFilter createPurgeArtifactsFilter(MavenProject theProject, List<Dependency> dependencies, Set<Artifact> purgedArtifacts) {
        ArrayList<Object> subFilters = new ArrayList<Object>();
        subFilters.add(ScopeFilter.excluding((String[])new String[]{"system"}));
        if (this.snapshotsOnly) {
            subFilters.add((Object)new SnapshotsFilter());
        }
        if (!StringUtils.isEmpty((CharSequence)this.include)) {
            this.includes = this.parseIncludes(this.include);
        }
        if (this.includes != null) {
            subFilters.add(new PatternInclusionsFilter(this.includes));
        }
        if (!StringUtils.isEmpty((CharSequence)this.exclude)) {
            this.excludes = this.parseIncludes(this.exclude);
        }
        if (this.excludes != null) {
            subFilters.add(new PatternExclusionsFilter(this.excludes));
        }
        if (!this.actTransitively) {
            subFilters.add((Object)new DirectDependencyFilter(theProject.getArtifact(), dependencies));
        }
        ArrayList<String> exclusions = new ArrayList<String>(this.reactorProjects.size());
        for (MavenProject reactorProject : this.reactorProjects) {
            exclusions.add(this.toPatternExcludes(reactorProject.getArtifact()));
        }
        for (Artifact purgedArtifact : purgedArtifacts) {
            exclusions.add(this.toPatternExcludes(purgedArtifact));
        }
        subFilters.add(new PatternExclusionsFilter(exclusions));
        return new AndFilter(subFilters);
    }

    private String toPatternExcludes(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getArtifactHandler().getExtension() + ":" + artifact.getVersion();
    }

    private List<String> parseIncludes(String theInclude) {
        ArrayList<String> theIncludes = new ArrayList<String>();
        if (theInclude != null) {
            String[] elements = theInclude.split(",");
            theIncludes.addAll(Arrays.asList(elements));
        }
        return theIncludes;
    }

    private Set<Artifact> getFilteredResolvedArtifacts(MavenProject theProject, List<Dependency> dependencies, TransformableFilter filter) {
        try {
            Iterable results = this.dependencyResolver.resolveDependencies(this.session.getProjectBuildingRequest(), theProject.getModel(), filter);
            LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
            for (ArtifactResult artResult : results) {
                resolvedArtifacts.add(artResult.getArtifact());
            }
            return resolvedArtifacts;
        }
        catch (DependencyResolverException e) {
            this.getLog().info((CharSequence)("Unable to resolve all dependencies for: " + this.getProjectKey(theProject) + ". Falling back to non-transitive mode for initial artifact resolution."));
            LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
            ArtifactFilter artifactFilter = (ArtifactFilter)filter.transform((FilterTransformer)new ArtifactIncludeFilterTransformer());
            for (Dependency dependency : dependencies) {
                DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
                coordinate.setGroupId(dependency.getGroupId());
                coordinate.setArtifactId(dependency.getArtifactId());
                coordinate.setVersion(dependency.getVersion());
                coordinate.setExtension(this.artifactHandlerManager.getArtifactHandler(dependency.getType()).getExtension());
                try {
                    Artifact artifact = this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), (ArtifactCoordinate)coordinate).getArtifact();
                    if (!artifactFilter.include(artifact)) continue;
                    resolvedArtifacts.add(artifact);
                }
                catch (ArtifactResolverException e2) {
                    this.getLog().debug((CharSequence)("Unable to resolve artifact: " + coordinate));
                }
            }
            return resolvedArtifacts;
        }
    }

    private void purgeArtifacts(MavenProject theProject, Set<Artifact> artifacts) {
        MessageBuilder messageBuilder = MessageUtils.buffer();
        this.getLog().info((CharSequence)messageBuilder.a((CharSequence)"Deleting ").strong((Object)artifacts.size()).a((CharSequence)" ").strong((Object)(this.actTransitively ? "transitive" : "direct")).a((CharSequence)(artifacts.size() != 1 ? " dependencies" : " dependency")).a((CharSequence)" for project ").strong((Object)this.getProjectKey(theProject)).a((CharSequence)" from ").strong((Object)this.localRepository.getBasedir()).a((CharSequence)" with artifact ").strong((Object)this.resolutionFuzziness).a((CharSequence)" resolution fuzziness").toString());
        for (Artifact artifact : artifacts) {
            this.verbose("Purging artifact: " + artifact.getId());
            File deleteTarget = this.findDeleteTarget(artifact);
            this.verbose("Deleting: " + deleteTarget);
            if (deleteTarget.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)deleteTarget);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Unable to purge local repository location: " + deleteTarget), (Throwable)e);
                }
            } else if (!deleteTarget.delete()) {
                deleteTarget.deleteOnExit();
                this.getLog().warn((CharSequence)("Unable to purge local repository location immediately: " + deleteTarget));
            }
            artifact.setResolved(false);
        }
    }

    private void reResolveArtifacts(MavenProject theProject, Set<Artifact> artifacts) throws ArtifactResolutionException {
        for (Artifact artifact : artifacts) {
            this.verbose("Resolving artifact: " + artifact.getId());
            try {
                this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), TransferUtils.toArtifactCoordinate((Artifact)artifact));
            }
            catch (ArtifactResolverException e) {
                this.verbose(e.getMessage());
            }
        }
        ArrayList<Artifact> missingArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            try {
                this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), artifact);
            }
            catch (ArtifactResolverException e) {
                this.verbose(e.getMessage());
                missingArtifacts.add(artifact);
            }
        }
        if (missingArtifacts.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder("required artifacts missing:");
            stringBuilder.append(System.lineSeparator());
            for (Artifact missingArtifact : missingArtifacts) {
                stringBuilder.append("  ").append(missingArtifact.getId()).append(System.lineSeparator());
            }
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("for the artifact:");
            throw new ArtifactResolutionException(stringBuilder.toString(), theProject.getArtifact(), theProject.getRemoteArtifactRepositories());
        }
    }

    private File findDeleteTarget(Artifact artifact) {
        File deleteTarget = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        if (GROUP_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile().getParentFile();
        } else if (ARTIFACT_ID_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile().getParentFile();
        } else if (VERSION_FUZZINESS.equals(this.resolutionFuzziness)) {
            deleteTarget = deleteTarget.getParentFile();
        }
        return deleteTarget;
    }

    private void verbose(String message) {
        if (this.verbose || this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }

    private String getProjectKey(MavenProject project) {
        return project.getArtifactId();
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private static class SnapshotsFilter
    extends AbstractFilter {
        private SnapshotsFilter() {
        }

        public boolean accept(Node node, List<Node> parents) {
            if (node.getDependency() == null) {
                return false;
            }
            return ArtifactUtils.isSnapshot((String)node.getDependency().getVersion());
        }
    }

    private class DirectDependencyFilter
    extends AbstractFilter {
        private final Artifact projectArtifact;
        private final List<Dependency> directDependencies;

        DirectDependencyFilter(Artifact projectArtifact, List<Dependency> directDependencies) {
            this.projectArtifact = projectArtifact;
            this.directDependencies = directDependencies;
        }

        public boolean accept(Node node, List<Node> parents) {
            if (this.artifactsGAMatch(node, this.projectArtifact.getGroupId(), this.projectArtifact.getArtifactId())) {
                return true;
            }
            for (Dependency dep : this.directDependencies) {
                if (!this.artifactsGAMatch(node, dep.getGroupId(), dep.getArtifactId())) continue;
                return true;
            }
            return false;
        }

        private boolean artifactsGAMatch(Node node, String groupId, String artifactId) {
            if (node.getDependency() == null) {
                return false;
            }
            if (!node.getDependency().getGroupId().equals(groupId)) {
                PurgeLocalRepositoryMojo.this.getLog().debug((CharSequence)("Different groupId: " + node.getDependency() + "  " + groupId));
                return false;
            }
            if (!node.getDependency().getArtifactId().equals(artifactId)) {
                PurgeLocalRepositoryMojo.this.getLog().debug((CharSequence)("Different artifactId: " + node.getDependency() + "  " + artifactId));
                return false;
            }
            return true;
        }
    }
}

