/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="get", requiresProject=false, threadSafe=true)
public class GetMojo
extends AbstractMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Component
    private RepositorySystem repositorySystem;
    private DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="transitive", defaultValue="true")
    private boolean transitive = true;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (this.coordinate.getArtifactId() == null && this.artifact == null) {
            throw new MojoFailureException("You must specify an artifact, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0");
        }
        if (this.artifact != null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + this.artifact);
            }
            this.coordinate.setGroupId(tokens[0]);
            this.coordinate.setArtifactId(tokens[1]);
            this.coordinate.setVersion(tokens[2]);
            if (tokens.length >= 4) {
                this.coordinate.setType(tokens[3]);
            }
            if (tokens.length == 5) {
                this.coordinate.setClassifier(tokens[4]);
            }
        }
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
        if (this.pomRemoteRepositories != null) {
            repoList.addAll(this.pomRemoteRepositories);
        }
        if (this.remoteRepositories != null) {
            String[] repos;
            for (String repo : repos = StringUtils.split((String)this.remoteRepositories, (String)",")) {
                repoList.add(this.parseRepository(repo, always));
            }
        }
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            Settings settings = this.session.getSettings();
            this.repositorySystem.injectMirror(repoList, settings.getMirrors());
            this.repositorySystem.injectProxy(repoList, settings.getProxies());
            this.repositorySystem.injectAuthentication(repoList, settings.getServers());
            buildingRequest.setRemoteRepositories(repoList);
            if (this.transitive) {
                this.getLog().info((CharSequence)("Resolving " + this.coordinate + " with transitive dependencies"));
                this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, (DependableCoordinate)this.coordinate, null);
            } else {
                this.getLog().info((CharSequence)("Resolving " + this.coordinate));
                this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, this.toArtifactCoordinate((DependableCoordinate)this.coordinate));
            }
        }
        catch (ArtifactResolverException | DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)e);
        }
    }

    private ArtifactCoordinate toArtifactCoordinate(DependableCoordinate dependableCoordinate) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(dependableCoordinate.getType());
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(dependableCoordinate.getGroupId());
        artifactCoordinate.setArtifactId(dependableCoordinate.getArtifactId());
        artifactCoordinate.setVersion(dependableCoordinate.getVersion());
        artifactCoordinate.setClassifier(dependableCoordinate.getClassifier());
        artifactCoordinate.setExtension(artifactHandler.getExtension());
        return artifactCoordinate;
    }

    ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    @Parameter(property="groupId")
    public void setGroupId(String groupId) {
        this.coordinate.setGroupId(groupId);
    }

    @Parameter(property="artifactId")
    public void setArtifactId(String artifactId) {
        this.coordinate.setArtifactId(artifactId);
    }

    @Parameter(property="version")
    public void setVersion(String version) {
        this.coordinate.setVersion(version);
    }

    @Parameter(property="classifier")
    public void setClassifier(String classifier) {
        this.coordinate.setClassifier(classifier);
    }

    @Parameter(property="packaging", defaultValue="jar")
    public void setPackaging(String type) {
        this.coordinate.setType(type);
    }
}

