/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;

public final class DependencyUtil {
    public static String getFormattedFileName(Artifact artifact, boolean removeVersion) {
        String destFileName = null;
        if (artifact.getFile() != null && !removeVersion) {
            destFileName = artifact.getFile().getName();
        } else {
            String versionString = null;
            versionString = !removeVersion ? "-" + artifact.getVersion() : "";
            String classifierString = "";
            if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
                classifierString = "-" + artifact.getClassifier();
            }
            destFileName = artifact.getArtifactId() + versionString + classifierString + "." + artifact.getType();
        }
        return destFileName;
    }

    public static File getFormattedOutputDirectory(boolean useSubdirsPerType, boolean useSubdirPerArtifact, File outputDirectory, Artifact artifact) {
        File result = null;
        String artifactId = artifact.getId().replace(':', '-');
        result = !useSubdirsPerType ? (useSubdirPerArtifact ? new File(outputDirectory.getAbsolutePath() + File.separatorChar + artifactId + File.separatorChar) : outputDirectory) : (useSubdirPerArtifact ? new File(outputDirectory.getAbsolutePath() + File.separatorChar + artifact.getType() + "s" + File.separatorChar + artifactId + File.separatorChar) : new File(outputDirectory.getAbsolutePath() + File.separatorChar + artifact.getType() + "s" + File.separatorChar));
        return result;
    }
}

