/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

final class ModuleInfoOverwrite
implements Runnable {
    private final Path testSourceFile;
    private final Path savedSourceFile;
    private final Path moduleInfoToHide;
    private final Path moduleInfoBackup;
    private final Path moduleInfoReplacement;
    private Thread shutdownHook;

    private ModuleInfoOverwrite(Path source, Path main, Path test) {
        this.testSourceFile = source;
        this.savedSourceFile = source.resolveSibling("module-info.java.bak");
        this.moduleInfoToHide = main;
        this.moduleInfoBackup = main.resolveSibling("module-info.class.bak");
        this.moduleInfoReplacement = test;
    }

    static ModuleInfoOverwrite create(Path source, Path mainOutputDirectory, Path testOutputDirectory) throws IOException {
        Path test;
        Path main = mainOutputDirectory.resolve("module-info.class");
        if (Files.isRegularFile(main, new LinkOption[0]) && Files.isRegularFile(test = testOutputDirectory.resolve("module-info.class"), new LinkOption[0])) {
            ModuleInfoOverwrite mo = new ModuleInfoOverwrite(source, main, test);
            mo.substitute();
            return mo;
        }
        return null;
    }

    private void substitute() throws IOException {
        Files.move(this.testSourceFile, this.savedSourceFile, new CopyOption[0]);
        Files.move(this.moduleInfoToHide, this.moduleInfoBackup, new CopyOption[0]);
        Files.move(this.moduleInfoReplacement, this.moduleInfoToHide, new CopyOption[0]);
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    void restore() throws IOException {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        Files.move(this.savedSourceFile, this.testSourceFile, new CopyOption[0]);
        Files.move(this.moduleInfoToHide, this.moduleInfoReplacement, new CopyOption[0]);
        Files.move(this.moduleInfoBackup, this.moduleInfoToHide, new CopyOption[0]);
    }

    @Override
    public void run() {
        this.shutdownHook = null;
        try {
            this.restore();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

