/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.checkstyle.resource;

import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.resource.DefaultResourceManager;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.resource.loader.ThreadContextClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ResourceManager.class, hint="license", instantiationStrategy="per-lookup")
public class LicenseResourceManager
extends DefaultResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseResourceManager.class);
    @Requirement(role=ResourceLoader.class)
    private Map<String, ResourceLoader> resourceLoaders;

    @Inject
    public LicenseResourceManager(Map<String, ResourceLoader> resourceLoaders) {
        super(resourceLoaders);
    }

    public void addSearchPath(String id, String path) {
        ResourceLoader loader = this.resourceLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("unknown resource loader: " + id);
        }
        loader.addSearchPath(path);
    }

    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            if (resourceLoader instanceof ThreadContextClasspathResourceLoader && !"config/maven-header.txt".equals(name)) continue;
            try {
                PlexusResource resource = resourceLoader.getResource(name);
                LOGGER.debug("The resource '" + name + "' was found as " + resource.getName() + ".");
                return resource;
            }
            catch (ResourceNotFoundException e) {
                LOGGER.debug("The resource '" + name + "' was not found with resourceLoader " + resourceLoader.getClass().getName() + ".");
            }
        }
        throw new ResourceNotFoundException(name);
    }
}

