/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.issues;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.changes.issues.AbstractIssuesReportRenderer;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.plugins.changes.issues.IssuesReportHelper;

public class IssuesReportRenderer
extends AbstractIssuesReportRenderer {
    private static final String NOT_AVAILABLE = "n/a";
    private final List<Integer> columns;
    private final List<Issue> issueList;

    public IssuesReportRenderer(Sink sink, ResourceBundle bundle, List<Integer> includedColumns, List<Issue> issueList) {
        super(sink, bundle);
        this.columns = includedColumns;
        this.issueList = issueList;
    }

    public void renderBody() {
        if (this.issueList == null || this.issueList.isEmpty()) {
            this.paragraph(this.bundle.getString("report.issues.error"));
        } else {
            this.startTable();
            this.constructHeaderRow();
            this.constructDetailRows();
            this.endTable();
        }
    }

    private void constructHeaderRow() {
        this.sink.tableRow();
        for (int column : this.columns) {
            switch (column) {
                case 0: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.assignee"));
                    break;
                }
                case 1: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.component"));
                    break;
                }
                case 2: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.created"));
                    break;
                }
                case 3: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.fixVersion"));
                    break;
                }
                case 4: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.id"));
                    break;
                }
                case 5: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.key"));
                    break;
                }
                case 6: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.priority"));
                    break;
                }
                case 7: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.reporter"));
                    break;
                }
                case 8: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.resolution"));
                    break;
                }
                case 9: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.status"));
                    break;
                }
                case 10: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.summary"));
                    break;
                }
                case 11: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.type"));
                    break;
                }
                case 12: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.updated"));
                    break;
                }
                case 13: {
                    this.tableHeaderCell(this.bundle.getString("report.issues.label.version"));
                    break;
                }
            }
        }
        this.sink.tableRow_();
    }

    private void constructDetailRows() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (Issue issue : this.issueList) {
            this.sink.tableRow();
            for (int column : this.columns) {
                switch (column) {
                    case 0: {
                        this.sinkCell(issue.getAssignee());
                        break;
                    }
                    case 1: {
                        this.sinkCell(IssuesReportHelper.printValues(issue.getComponents()));
                        break;
                    }
                    case 2: {
                        String created = NOT_AVAILABLE;
                        if (issue.getCreated() != null) {
                            created = df.format(issue.getCreated());
                        }
                        this.sinkCell(created);
                        break;
                    }
                    case 3: {
                        this.sinkCell(IssuesReportHelper.printValues(issue.getFixVersions()));
                        break;
                    }
                    case 4: {
                        this.sinkCellLink(issue.getId(), issue.getLink());
                        break;
                    }
                    case 5: {
                        this.sinkCellLink(issue.getKey(), issue.getLink());
                        break;
                    }
                    case 6: {
                        this.sinkCell(issue.getPriority());
                        break;
                    }
                    case 7: {
                        this.sinkCell(issue.getReporter());
                        break;
                    }
                    case 8: {
                        this.sinkCell(issue.getResolution());
                        break;
                    }
                    case 9: {
                        this.sinkCell(issue.getStatus());
                        break;
                    }
                    case 10: {
                        this.sinkCell(issue.getSummary());
                        break;
                    }
                    case 11: {
                        this.sinkCell(issue.getType());
                        break;
                    }
                    case 12: {
                        String updated = NOT_AVAILABLE;
                        if (issue.getUpdated() != null) {
                            updated = df.format(issue.getUpdated());
                        }
                        this.sinkCell(updated);
                        break;
                    }
                    case 13: {
                        this.sinkCell(issue.getVersion());
                        break;
                    }
                }
            }
            this.sink.tableRow_();
        }
    }
}

