/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.artifact;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.ModuleSetAssemblyPhase;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.artifact.DependencyResolver;
import org.apache.maven.plugins.assembly.artifact.ResolutionManagementInfo;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultDependencyResolver
implements DependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDependencyResolver.class);
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultDependencyResolver(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem) {
        this.artifactHandlerManager = Objects.requireNonNull(artifactHandlerManager);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, ModuleSet moduleSet, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo();
            this.updateDependencySetResolutionRequirements(configSource.getMavenSession().getRepositorySession(), dependencySet, info, currentProject);
            this.updateModuleSetResolutionRequirements(moduleSet, dependencySet, info, configSource);
            result.put(dependencySet, info.getArtifacts());
        }
        return result;
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo();
            this.updateDependencySetResolutionRequirements(configSource.getMavenSession().getRepositorySession(), dependencySet, info, currentProject);
            result.put(dependencySet, info.getArtifacts());
        }
        return result;
    }

    void updateModuleSetResolutionRequirements(ModuleSet set, DependencySet dependencySet, ResolutionManagementInfo requirements, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        ModuleBinaries binaries = set.getBinaries();
        if (binaries != null) {
            Set<MavenProject> projects;
            try {
                projects = ModuleSetAssemblyPhase.getModuleProjects(set, configSource, LOGGER);
            }
            catch (ArchiveCreationException e) {
                throw new DependencyResolutionException("Error determining project-set for moduleSet with binaries.", e);
            }
            for (MavenProject p : projects) {
                if (p.getArtifact() != null) continue;
                p.setArtifact(this.createArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion(), p.getPackaging()));
            }
            if (binaries.isIncludeDependencies()) {
                this.updateDependencySetResolutionRequirements(configSource.getMavenSession().getRepositorySession(), dependencySet, requirements, projects.toArray(new MavenProject[0]));
            }
        }
    }

    private Artifact createArtifact(String groupId, String artifactId, String version, String type) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion((String)version);
        }
        return new DefaultArtifact(groupId, artifactId, versionRange, null, type, null, this.artifactHandlerManager.getArtifactHandler(type), false);
    }

    void updateDependencySetResolutionRequirements(RepositorySystemSession systemSession, DependencySet set, ResolutionManagementInfo requirements, MavenProject ... projects) throws DependencyResolutionException {
        for (MavenProject project : projects) {
            if (project == null) continue;
            Set<Artifact> dependencyArtifacts = null;
            if (set.isUseTransitiveDependencies()) {
                try {
                    dependencyArtifacts = this.resolveTransitive(systemSession, set.getScope(), project);
                }
                catch (org.eclipse.aether.resolution.DependencyResolutionException e) {
                    throw new DependencyResolutionException(e.getMessage(), e);
                }
            } else {
                dependencyArtifacts = project.getDependencyArtifacts();
            }
            requirements.addArtifacts(dependencyArtifacts);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Dependencies for project: {} are:\n{}", (Object)project.getId(), (Object)StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
        }
    }

    private Set<Artifact> resolveTransitive(RepositorySystemSession repositorySession, String scope, MavenProject project) throws org.eclipse.aether.resolution.DependencyResolutionException {
        DependencyFilter scoopeDependencyFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{scope});
        List dependencies = project.getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)repositorySession.getArtifactTypeRegistry())).filter(d -> scoopeDependencyFilter.accept((DependencyNode)new DefaultDependencyNode(d), null)).collect(Collectors.toList());
        List managedDependencies = Optional.ofNullable(project.getDependencyManagement()).map(DependencyManagement::getDependencies).map(list -> list.stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)repositorySession.getArtifactTypeRegistry())).collect(Collectors.toList())).orElse(null);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(project.getRemoteProjectRepositories());
        collectRequest.setDependencies(dependencies);
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)project.getArtifact()));
        DependencyRequest request = new DependencyRequest(collectRequest, scoopeDependencyFilter);
        DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(repositorySession, request);
        final HashMap aetherToMavenArtifacts = new HashMap();
        final ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(project.getArtifact().getId());
        final HashSet<Artifact> artifacts = new HashSet<Artifact>();
        dependencyResult.getRoot().accept(new DependencyVisitor(){
            final /* synthetic */ DefaultDependencyResolver this$0;
            {
                this.this$0 = this$0;
            }

            public boolean visitEnter(DependencyNode node) {
                if (node.getDependency() != null) {
                    stack.push(aetherToMavenArtifacts.computeIfAbsent(node.getDependency().getArtifact(), RepositoryUtils::toArtifact).getId());
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                org.eclipse.aether.graph.Dependency dependency = node.getDependency();
                if (dependency != null) {
                    Artifact artifact = aetherToMavenArtifacts.computeIfAbsent(dependency.getArtifact(), RepositoryUtils::toArtifact);
                    if (artifact.isResolved() && artifact.getFile() != null) {
                        ArrayList depTrail = new ArrayList();
                        stack.descendingIterator().forEachRemaining(depTrail::add);
                        artifact.setDependencyTrail(depTrail);
                        artifact.setOptional(dependency.isOptional());
                        artifact.setScope(dependency.getScope());
                        artifacts.add(artifact);
                    }
                    stack.pop();
                }
                return true;
            }
        });
        return artifacts;
    }
}

