/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.UnpackOptions;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.Logger;

public class AddDependencySetsTask
implements ArchiverTask {
    private static final List NON_ARCHIVE_DEPENDENCY_TYPES;
    private final List dependencySets;
    private final Logger logger;
    private final MavenProject project;
    private MavenProject moduleProject;
    private final MavenProjectBuilder projectBuilder;
    private String defaultOutputDirectory;
    private String defaultOutputFileNameMapping;
    private final DependencyResolver dependencyResolver;
    private final Map managedVersions;
    private Artifact moduleArtifact;

    public AddDependencySetsTask(List dependencySets, MavenProject project, Map managedVersions, MavenProjectBuilder projectBuilder, DependencyResolver dependencyResolver, Logger logger) {
        this.dependencySets = dependencySets;
        this.project = project;
        this.managedVersions = managedVersions;
        this.projectBuilder = projectBuilder;
        this.dependencyResolver = dependencyResolver;
        this.logger = logger;
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (this.dependencySets == null || this.dependencySets.isEmpty()) {
            this.logger.debug("No dependency sets specified.");
            return;
        }
        List deps = this.project.getDependencies();
        if (deps == null || deps.isEmpty()) {
            this.logger.debug("Project " + this.project.getId() + " has no dependencies. Skipping dependency set addition.");
        }
        Iterator i = this.dependencySets.iterator();
        while (i.hasNext()) {
            DependencySet dependencySet = (DependencySet)i.next();
            this.addDependencySet(dependencySet, archiver, configSource);
        }
    }

    protected void addDependencySet(DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException, InvalidAssemblerConfigurationException {
        this.logger.debug("Processing DependencySet (output=" + dependencySet.getOutputDirectory() + ")");
        if (!dependencySet.isUseTransitiveDependencies() && dependencySet.isUseTransitiveFiltering()) {
            this.logger.warn("DependencySet has nonsensical configuration: useTransitiveDependencies == false AND useTransitiveFiltering == true. Transitive filtering flag will be ignored.");
        }
        Set dependencyArtifacts = this.resolveDependencyArtifacts(dependencySet, configSource);
        this.logger.debug("Adding " + dependencyArtifacts.size() + " dependency artifacts.");
        Iterator j = dependencyArtifacts.iterator();
        while (j.hasNext()) {
            int fileMode;
            MavenProject depProject;
            Artifact depArtifact = (Artifact)j.next();
            try {
                depProject = this.projectBuilder.buildFromRepository(depArtifact, configSource.getRemoteRepositories(), configSource.getLocalRepository());
            }
            catch (ProjectBuildingException e) {
                this.logger.debug("Error retrieving POM of module-dependency: " + depArtifact.getId() + "; Reason: " + e.getMessage() + "\n\nBuilding stub project instance.");
                depProject = this.buildProjectStub(depArtifact);
            }
            if (NON_ARCHIVE_DEPENDENCY_TYPES.contains(depArtifact.getType())) {
                this.addNonArchiveDependency(depArtifact, depProject, dependencySet, archiver, configSource);
                continue;
            }
            AddArtifactTask task = new AddArtifactTask(depArtifact, this.logger);
            task.setProject(depProject);
            task.setModuleProject(this.moduleProject);
            task.setModuleArtifact(this.moduleArtifact);
            task.setOutputDirectory(dependencySet.getOutputDirectory(), this.defaultOutputDirectory);
            task.setFileNameMapping(dependencySet.getOutputFileNameMapping(), this.defaultOutputFileNameMapping);
            int dirMode = TypeConversionUtils.modeToInt(dependencySet.getDirectoryMode(), this.logger);
            if (dirMode != -1) {
                task.setDirectoryMode(dirMode);
            }
            if ((fileMode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), this.logger)) != -1) {
                task.setFileMode(fileMode);
            }
            task.setUnpack(dependencySet.isUnpack());
            UnpackOptions opts = dependencySet.getUnpackOptions();
            if (dependencySet.isUnpack() && opts != null) {
                task.setIncludes(opts.getIncludes());
                task.setExcludes(opts.getExcludes());
            }
            task.execute(archiver, configSource);
        }
    }

    private MavenProject buildProjectStub(Artifact depArtifact) {
        Model model = new Model();
        model.setGroupId(depArtifact.getGroupId());
        model.setArtifactId(depArtifact.getArtifactId());
        model.setVersion(depArtifact.getBaseVersion());
        model.setPackaging(depArtifact.getType());
        model.setDescription("Stub for " + depArtifact.getId());
        return new MavenProject(model);
    }

    protected Set resolveDependencyArtifacts(DependencySet dependencySet, AssemblerConfigurationSource configSource) throws ArchiveCreationException, InvalidAssemblerConfigurationException {
        List attachments;
        LinkedHashSet<Artifact> dependencyArtifacts;
        ArtifactRepository localRepository = configSource.getLocalRepository();
        List additionalRemoteRepositories = configSource.getRemoteRepositories();
        try {
            dependencyArtifacts = this.dependencyResolver.resolveDependencies(this.project, dependencySet.getScope(), this.managedVersions, localRepository, additionalRemoteRepositories, dependencySet.isUseTransitiveDependencies());
            if (dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
                dependencyArtifacts = new LinkedHashSet<Artifact>(dependencyArtifacts);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new ArchiveCreationException("Failed to resolve dependencies for project: " + this.project.getId(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new ArchiveCreationException("Failed to resolve dependencies for project: " + this.project.getId(), e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new ArchiveCreationException("Failed to resolve dependencies for project: " + this.project.getId(), e);
        }
        if (dependencySet.isUseProjectArtifact()) {
            Artifact projectArtifact = this.project.getArtifact();
            if (projectArtifact != null && projectArtifact.getFile() != null) {
                dependencyArtifacts.add(projectArtifact);
            } else {
                this.logger.warn("Cannot include project artifact: " + projectArtifact + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseProjectAttachments() && (attachments = this.project.getAttachedArtifacts()) != null) {
            Iterator attachmentIt = attachments.iterator();
            while (attachmentIt.hasNext()) {
                Artifact attachment = (Artifact)attachmentIt.next();
                if (attachment.getFile() != null) {
                    dependencyArtifacts.add(attachment);
                    continue;
                }
                this.logger.warn("Cannot include attached artifact: " + this.project.getId() + " for project: " + this.project.getId() + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseTransitiveFiltering()) {
            this.logger.debug("Filtering dependency artifacts USING transitive dependency path information.");
        } else {
            this.logger.debug("Filtering dependency artifacts WITHOUT transitive dependency path information.");
        }
        FilterUtils.filterArtifacts(dependencyArtifacts, dependencySet.getIncludes(), dependencySet.getExcludes(), dependencySet.isUseStrictFiltering(), dependencySet.isUseTransitiveFiltering(), Collections.EMPTY_LIST, this.logger);
        return dependencyArtifacts;
    }

    protected void addNonArchiveDependency(Artifact depArtifact, MavenProject depProject, DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException {
        File source = depArtifact.getFile();
        String outputDirectory = dependencySet.getOutputDirectory();
        outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory, configSource.getProject(), this.moduleProject, depProject, depProject.getBuild().getFinalName(), configSource);
        String destName = AssemblyFormatUtils.evaluateFileNameMapping(dependencySet.getOutputFileNameMapping(), depArtifact, configSource.getProject(), this.moduleProject, this.moduleArtifact, depProject, configSource);
        String target = outputDirectory.endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : outputDirectory + "/" + destName;
        try {
            int mode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), this.logger);
            if (mode > -1) {
                archiver.addFile(source, target, mode);
            } else {
                archiver.addFile(source, target);
            }
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
        }
    }

    public List getDependencySets() {
        return this.dependencySets;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getDefaultOutputDirectory() {
        return this.defaultOutputDirectory;
    }

    public void setDefaultOutputDirectory(String defaultOutputDirectory) {
        this.defaultOutputDirectory = defaultOutputDirectory;
    }

    public String getDefaultOutputFileNameMapping() {
        return this.defaultOutputFileNameMapping;
    }

    public void setDefaultOutputFileNameMapping(String defaultOutputFileNameMapping) {
        this.defaultOutputFileNameMapping = defaultOutputFileNameMapping;
    }

    public MavenProject getModuleProject() {
        return this.moduleProject;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    public Artifact getModuleArtifact() {
        return this.moduleArtifact;
    }

    static {
        ArrayList<String> nonArch = new ArrayList<String>();
        nonArch.add("pom");
        NON_ARCHIVE_DEPENDENCY_TYPES = Collections.unmodifiableList(nonArch);
    }
}

