/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.assembly.utils.PropertiesInterpolationValueSource;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getInterpolatedPropertiesFromFile(File propfile, boolean fail, boolean useSystemProps) throws IOException {
        Properties props = useSystemProps ? new Properties(System.getProperties()) : new Properties();
        if (propfile.exists()) {
            FileInputStream inStream = new FileInputStream(propfile);
            try {
                props.load(inStream);
            }
            finally {
                IOUtil.close((InputStream)inStream);
            }
        } else if (fail) {
            throw new FileNotFoundException(propfile.toString());
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(props));
        Enumeration<?> n = props.propertyNames();
        while (n.hasMoreElements()) {
            String key = (String)n.nextElement();
            String value = interpolator.interpolate(props.getProperty(key), "__properties");
            props.setProperty(key, value);
        }
        return props;
    }
}

