/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.AbstractUnpackingMojo;

public class UnpackMojo
extends AbstractUnpackingMojo {
    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error unpacking", e);
        }
    }

    private void doExecute() throws Exception {
        Iterator j = this.dependencies.iterator();
        while (j.hasNext()) {
            Artifact artifact = (Artifact)j.next();
            String name = artifact.getFile().getName();
            File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
            boolean process = false;
            if (!tempLocation.exists()) {
                tempLocation.mkdirs();
                process = true;
            } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                process = true;
            }
            if (!process) continue;
            File file = artifact.getFile();
            this.unpack(file, tempLocation);
        }
    }
}

