/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

public class PluginHelpGenerator
extends AbstractLogEnabled
implements Generator {
    private static final String HELP_MOJO_CLASS_NAME = "HelpMojo";
    private static final String HELP_GOAL = "help";
    private String helpPackageName;
    private VelocityComponent velocityComponent;

    public PluginHelpGenerator() {
        this.enableLogging((Logger)new ConsoleLogger(1, "PluginHelpGenerator"));
    }

    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        PluginDescriptor pluginDescriptor = request.getPluginDescriptor();
        String helpImplementation = this.getImplementation(pluginDescriptor);
        List mojoDescriptors = pluginDescriptor.getMojos();
        if (mojoDescriptors != null) {
            for (MojoDescriptor descriptor : mojoDescriptors) {
                if (!HELP_GOAL.equals(descriptor.getGoal()) || descriptor.getImplementation().equals(helpImplementation)) continue;
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("\n\nA help goal (" + descriptor.getImplementation() + ") already exists in this plugin. SKIPPED THE " + helpImplementation + " GENERATION.\n");
                }
                return;
            }
        }
        Properties properties = new Properties();
        properties.put("helpPackageName", this.helpPackageName == null ? "" : this.helpPackageName);
        MavenProject mavenProject = request.getProject();
        String propertiesFilePath = "META-INF/maven/" + mavenProject.getGroupId() + "/" + mavenProject.getArtifactId();
        File tmpPropertiesFile = new File(request.getProject().getBuild().getDirectory(), "maven-plugin-help.properties");
        if (tmpPropertiesFile.exists()) {
            tmpPropertiesFile.delete();
        } else if (!tmpPropertiesFile.getParentFile().exists()) {
            tmpPropertiesFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tmpPropertiesFile);
            properties.store(fos, "maven plugin help generation informations");
        }
        catch (IOException e) {
            try {
                throw new GeneratorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)fos);
        String sourcePath = helpImplementation.replace('.', File.separatorChar) + ".java";
        File helpClass = new File(destinationDirectory, sourcePath);
        helpClass.getParentFile().mkdirs();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(helpClass), request.getEncoding());
            writer.write(this.getHelpClassSources(propertiesFilePath));
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new GeneratorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public PluginHelpGenerator setHelpPackageName(String helpPackageName) {
        this.helpPackageName = helpPackageName;
        return this;
    }

    public VelocityComponent getVelocityComponent() {
        return this.velocityComponent;
    }

    public PluginHelpGenerator setVelocityComponent(VelocityComponent velocityComponent) {
        this.velocityComponent = velocityComponent;
        return this;
    }

    protected String getHelpClassSources(String propertiesFilePath) {
        Properties properties = new Properties();
        VelocityContext context = new VelocityContext((Map)properties);
        if (this.helpPackageName != null) {
            properties.put("helpPackageName", this.helpPackageName);
        } else {
            properties.put("helpPackageName", "");
        }
        properties.put("pluginHelpPath", propertiesFilePath + "/plugin-help.xml");
        StringWriter stringWriter = new StringWriter();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("help-class-source.vm");
        InputStreamReader isReader = new InputStreamReader(is);
        this.velocityComponent.getEngine().evaluate((Context)context, (Writer)stringWriter, "", (Reader)isReader);
        return stringWriter.toString();
    }

    private String getImplementation(PluginDescriptor pluginDescriptor) {
        String packageName = this.helpPackageName;
        if (StringUtils.isEmpty((String)packageName)) {
            packageName = GeneratorUtils.discoverPackageName(pluginDescriptor);
        }
        return StringUtils.isEmpty((String)packageName) ? HELP_MOJO_CLASS_NAME : packageName + '.' + HELP_MOJO_CLASS_NAME;
    }
}

