/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptedMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    @Override
    public List<MojoDescriptor> execute(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        List<MojoDescriptor> mojoDescriptors;
        this.getLogger().debug("Running: " + this.getClass().getName());
        String metadataExtension = this.getMetadataFileExtension(request);
        String scriptExtension = this.getScriptFileExtension(request);
        MavenProject project = request.getProject();
        Map<String, Set<File>> scriptFilesKeyedByBasedir = this.gatherFilesByBasedir(project.getBasedir(), project.getScriptSourceRoots(), scriptExtension, request);
        if (!StringUtils.isEmpty((String)metadataExtension)) {
            Map<String, Set<File>> metadataFilesKeyedByBasedir = this.gatherFilesByBasedir(project.getBasedir(), project.getScriptSourceRoots(), metadataExtension, request);
            mojoDescriptors = this.extractMojoDescriptorsFromMetadata(metadataFilesKeyedByBasedir, request);
        } else {
            mojoDescriptors = this.extractMojoDescriptors(scriptFilesKeyedByBasedir, request);
        }
        this.copyScriptsToOutputDirectory(scriptFilesKeyedByBasedir, project.getBuild().getOutputDirectory(), request);
        return mojoDescriptors;
    }

    protected void copyScriptsToOutputDirectory(Map<String, Set<File>> scriptFilesKeyedByBasedir, String outputDirectory, PluginToolsRequest request) throws ExtractionException {
        File outputDir = new File(outputDirectory);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        for (Map.Entry<String, Set<File>> entry : scriptFilesKeyedByBasedir.entrySet()) {
            File sourceDir = new File(entry.getKey());
            Set<File> scripts = entry.getValue();
            for (File scriptFile : scripts) {
                File outputFile;
                String relativePath = scriptFile.getPath().substring(sourceDir.getPath().length());
                if (relativePath.charAt(0) == File.separatorChar) {
                    relativePath = relativePath.substring(1);
                }
                if (!(outputFile = new File(outputDir, relativePath).getAbsoluteFile()).getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                try {
                    FileUtils.copyFile((File)scriptFile, (File)outputFile);
                }
                catch (IOException e) {
                    throw new ExtractionException("Cannot copy script file: " + scriptFile + " to output: " + outputFile, e);
                }
            }
        }
    }

    protected Map<String, Set<File>> gatherFilesByBasedir(File basedir, List<String> directories, String scriptFileExtension, PluginToolsRequest request) {
        TreeMap<String, Set<File>> sourcesByBasedir = new TreeMap<String, Set<File>>();
        for (String resourceDir : directories) {
            String[] relativePaths;
            HashSet<File> sources = new HashSet<File>();
            this.getLogger().debug("Scanning script dir: " + resourceDir + " with extractor: " + this.getClass().getName());
            File dir = new File(resourceDir);
            if (!dir.isAbsolute()) {
                dir = new File(basedir, resourceDir).getAbsoluteFile();
            }
            resourceDir = dir.getPath();
            if (!dir.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            scanner.addDefaultExcludes();
            scanner.setIncludes(new String[]{"**/*" + scriptFileExtension});
            scanner.scan();
            for (String relativePath : relativePaths = scanner.getIncludedFiles()) {
                File scriptFile = new File(dir, relativePath).getAbsoluteFile();
                if (!scriptFile.isFile() || !relativePath.endsWith(scriptFileExtension)) continue;
                sources.add(scriptFile);
            }
            sourcesByBasedir.put(resourceDir, sources);
        }
        return sourcesByBasedir;
    }

    protected List<MojoDescriptor> extractMojoDescriptorsFromMetadata(Map<String, Set<File>> metadataFilesByBasedir, PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        return null;
    }

    protected String getMetadataFileExtension(PluginToolsRequest request) {
        return null;
    }

    protected List<MojoDescriptor> extractMojoDescriptors(Map<String, Set<File>> scriptFilesKeyedByBasedir, PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        return null;
    }

    protected abstract String getScriptFileExtension(PluginToolsRequest var1);
}

