/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.converter.tag;

import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.javadoc.FullyQualifiedJavadocReference;
import org.apache.maven.tools.plugin.javadoc.JavadocReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LinkUtils.class);

    private LinkUtils() {
    }

    public static String createLink(String referenceValue, ConverterContext context) {
        return LinkUtils.createLink(referenceValue, context, UnaryOperator.identity());
    }

    public static String createLink(String referenceValue, ConverterContext context, UnaryOperator<String> labelDecorator) {
        try {
            JavadocReference reference = JavadocReference.parse((String)referenceValue);
            FullyQualifiedJavadocReference fqReference = context.resolveReference(reference);
            if (!context.canGetUrl()) {
                return LinkUtils.getReferenceLabel(fqReference, context, labelDecorator, "no javadoc sites associated");
            }
            return LinkUtils.createLink(referenceValue, fqReference, context, labelDecorator);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unresolvable link in javadoc tag with value {} found in {}: {}", new Object[]{referenceValue, context.getLocation(), e.getMessage()});
            return (String)labelDecorator.apply(referenceValue) + "<!-- this link could not be resolved -->";
        }
    }

    private static String createLink(String referenceValue, FullyQualifiedJavadocReference fqReference, ConverterContext context, UnaryOperator<String> labelDecorator) {
        StringBuilder link = new StringBuilder();
        try {
            link.append("<a href=\"");
            link.append(context.getUrl(fqReference).toString());
            link.append("\">");
            String label = LinkUtils.getReferenceLabel(fqReference, context);
            label = (String)labelDecorator.apply(label);
            link.append(label);
            link.append("</a>");
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not get javadoc URL for reference {} at {} (fully qualified {}): {}", new Object[]{referenceValue, fqReference, context.getLocation(), e.getMessage()});
            return LinkUtils.getReferenceLabel(fqReference, context, labelDecorator, "reference not found in associated javadoc sites");
        }
        return link.toString();
    }

    private static String getReferenceLabel(FullyQualifiedJavadocReference fqReference, ConverterContext context, UnaryOperator<String> labelDecorator, String htmlComment) {
        String label = LinkUtils.getReferenceLabel(fqReference, context);
        return (String)labelDecorator.apply(label) + "<!-- " + htmlComment + " -->";
    }

    private static String getReferenceLabel(FullyQualifiedJavadocReference fqReference, ConverterContext context) {
        Optional<String> moduleName;
        Optional<String> packageName;
        if (fqReference.getLabel().isPresent()) {
            return (String)fqReference.getLabel().get();
        }
        Optional className = fqReference.getClassName();
        if (Optional.of(context.getPackageName()).equals(fqReference.getPackageName()) && context.getModuleName().equals(fqReference.getModuleName())) {
            packageName = Optional.empty();
            moduleName = Optional.empty();
            if (context.isReferencedBy(fqReference)) {
                className = Optional.empty();
            }
        } else {
            packageName = fqReference.getPackageName();
            moduleName = fqReference.getModuleName();
        }
        return LinkUtils.createLabel(moduleName, packageName, className, fqReference.getMember());
    }

    private static String createLabel(Optional<String> moduleName, Optional<String> packageName, Optional<String> className, Optional<String> member) {
        StringBuilder sb = new StringBuilder();
        if (packageName.isPresent() && !"java.lang".equals(packageName.get())) {
            sb.append(packageName.get());
        }
        if (className.isPresent()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(className.get());
        }
        if (member.isPresent()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(member.get());
        }
        return sb.toString();
    }
}

