/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.annotations;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.InvalidParameterException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.annotations.datamodel.AnnotatedField;
import org.apache.maven.tools.plugin.annotations.datamodel.ComponentAnnotationContent;
import org.apache.maven.tools.plugin.annotations.datamodel.ExecuteAnnotationContent;
import org.apache.maven.tools.plugin.annotations.datamodel.MojoAnnotationContent;
import org.apache.maven.tools.plugin.annotations.datamodel.ParameterAnnotationContent;
import org.apache.maven.tools.plugin.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.annotations.scanner.MojoAnnotationsScannerRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MojoDescriptorExtractor.class, hint="java-annotations")
public class JavaAnnotationsMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    @Requirement
    private MojoAnnotationsScanner mojoAnnotationsScanner;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArchiverManager archiverManager;

    public List<MojoDescriptor> execute(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        return this.execute((PluginToolsRequest)new DefaultPluginToolsRequest(project, pluginDescriptor));
    }

    public List<MojoDescriptor> execute(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Map<String, MojoAnnotatedClass> mojoAnnotatedClasses = this.scanAnnotations(request);
        Map<String, JavaClass> javaClassesMap = this.scanJavadoc(request, mojoAnnotatedClasses.values());
        this.populateDataFromJavadoc(mojoAnnotatedClasses, javaClassesMap);
        return this.toMojoDescriptors(mojoAnnotatedClasses, request.getPluginDescriptor());
    }

    private Map<String, MojoAnnotatedClass> scanAnnotations(PluginToolsRequest request) throws ExtractionException {
        MojoAnnotationsScannerRequest mojoAnnotationsScannerRequest = new MojoAnnotationsScannerRequest();
        File output = new File(request.getProject().getBuild().getOutputDirectory());
        mojoAnnotationsScannerRequest.setClassesDirectories(Arrays.asList(output));
        mojoAnnotationsScannerRequest.setDependencies(request.getDependencies());
        mojoAnnotationsScannerRequest.setProject(request.getProject());
        return this.mojoAnnotationsScanner.scan(mojoAnnotationsScannerRequest);
    }

    private Map<String, JavaClass> scanJavadoc(PluginToolsRequest request, Collection<MojoAnnotatedClass> mojoAnnotatedClasses) throws ExtractionException {
        ArrayList<MavenProject> mavenProjects = new ArrayList<MavenProject>();
        HashSet<Artifact> externalArtifacts = new HashSet<Artifact>();
        for (MojoAnnotatedClass mojoAnnotatedClass : mojoAnnotatedClasses) {
            if (StringUtils.equals((String)mojoAnnotatedClass.getArtifact().getArtifactId(), (String)request.getProject().getArtifact().getArtifactId()) || !this.isMojoAnnnotatedClassCandidate(mojoAnnotatedClass)) continue;
            MavenProject mavenProject = this.getFromProjectReferences(mojoAnnotatedClass.getArtifact(), request.getProject());
            if (mavenProject != null) {
                mavenProjects.add(mavenProject);
                continue;
            }
            externalArtifacts.add(mojoAnnotatedClass.getArtifact());
        }
        HashMap<String, JavaClass> javaClassesMap = new HashMap<String, JavaClass>();
        for (Artifact artifact : externalArtifacts) {
            if (StringUtils.equalsIgnoreCase((String)"tests", (String)artifact.getClassifier())) {
                javaClassesMap.putAll(this.discoverClassesFromSourcesJar(artifact, request, "test-sources"));
                continue;
            }
            javaClassesMap.putAll(this.discoverClassesFromSourcesJar(artifact, request, "sources"));
        }
        for (MavenProject mavenProject : mavenProjects) {
            javaClassesMap.putAll(this.discoverClasses(request.getEncoding(), mavenProject));
        }
        javaClassesMap.putAll(this.discoverClasses(request));
        return javaClassesMap;
    }

    private boolean isMojoAnnnotatedClassCandidate(MojoAnnotatedClass mojoAnnotatedClass) {
        if (mojoAnnotatedClass == null) {
            return false;
        }
        return !mojoAnnotatedClass.getComponents().isEmpty() || !mojoAnnotatedClass.getParameters().isEmpty() || mojoAnnotatedClass.getExecute() != null || mojoAnnotatedClass.getMojo() != null;
    }

    protected Map<String, JavaClass> discoverClassesFromSourcesJar(Artifact artifact, PluginToolsRequest request, String classifier) throws ExtractionException {
        try {
            Artifact sourcesArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), classifier);
            this.artifactResolver.resolve(sourcesArtifact, request.getRemoteRepos(), request.getLocal());
            if (sourcesArtifact.getFile() == null || !sourcesArtifact.getFile().exists()) {
                return Collections.emptyMap();
            }
            File extractDirectory = new File(request.getProject().getBuild().getDirectory(), "maven-plugin-plugin-sources/" + sourcesArtifact.getGroupId() + "/" + sourcesArtifact.getArtifactId() + "/" + sourcesArtifact.getVersion() + "/" + sourcesArtifact.getClassifier());
            extractDirectory.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
            unArchiver.setSourceFile(sourcesArtifact.getFile());
            unArchiver.setDestDirectory(extractDirectory);
            unArchiver.extract();
            return this.discoverClasses(request.getEncoding(), Arrays.asList(extractDirectory));
        }
        catch (ArtifactResolutionException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            this.getLogger().debug("skip ArtifactNotFoundException:" + e.getMessage());
            this.getLogger().warn("Unable to get sources artifact for " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ". Some javadoc tags (@since, @deprecated and comments) won't be used");
            return Collections.emptyMap();
        }
        catch (NoSuchArchiverException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
    }

    protected void populateDataFromJavadoc(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, Map<String, JavaClass> javaClassesMap) {
        for (Map.Entry<String, MojoAnnotatedClass> entry : mojoAnnotatedClasses.entrySet()) {
            DocletTag since;
            DocletTag deprecated;
            JavaField javaField;
            JavaClass javaClass = javaClassesMap.get(entry.getKey());
            if (javaClass == null) continue;
            MojoAnnotationContent mojoAnnotationContent = entry.getValue().getMojo();
            if (mojoAnnotationContent != null) {
                DocletTag deprecated2;
                mojoAnnotationContent.setDescription(javaClass.getComment());
                DocletTag since2 = this.findInClassHierarchy(javaClass, "since");
                if (since2 != null) {
                    mojoAnnotationContent.setSince(since2.getValue());
                }
                if ((deprecated2 = this.findInClassHierarchy(javaClass, "deprecated")) != null) {
                    mojoAnnotationContent.setDeprecated(deprecated2.getValue());
                }
            }
            Map<String, JavaField> fieldsMap = this.extractFieldParameterTags(javaClass, javaClassesMap);
            Map<String, ParameterAnnotationContent> parameters = this.getParametersParentHierarchy(entry.getValue(), new HashMap<String, ParameterAnnotationContent>(), mojoAnnotatedClasses);
            for (Map.Entry<String, ParameterAnnotationContent> entry2 : new TreeMap<String, ParameterAnnotationContent>(parameters).entrySet()) {
                javaField = fieldsMap.get(entry2.getKey());
                if (javaField == null) continue;
                ParameterAnnotationContent parameterAnnotationContent = entry2.getValue();
                parameterAnnotationContent.setDescription(javaField.getComment());
                deprecated = javaField.getTagByName("deprecated");
                if (deprecated != null) {
                    parameterAnnotationContent.setDeprecated(deprecated.getValue());
                }
                if ((since = javaField.getTagByName("since")) == null) continue;
                parameterAnnotationContent.setSince(since.getValue());
            }
            for (Map.Entry<String, AnnotatedField> entry3 : entry.getValue().getComponents().entrySet()) {
                javaField = fieldsMap.get(entry3.getKey());
                if (javaField == null) continue;
                ComponentAnnotationContent componentAnnotationContent = (ComponentAnnotationContent)entry3.getValue();
                componentAnnotationContent.setDescription(javaField.getComment());
                deprecated = javaField.getTagByName("deprecated");
                if (deprecated != null) {
                    componentAnnotationContent.setDeprecated(deprecated.getValue());
                }
                if ((since = javaField.getTagByName("since")) == null) continue;
                componentAnnotationContent.setSince(since.getValue());
            }
        }
    }

    private DocletTag findInClassHierarchy(JavaClass javaClass, String tagName) {
        JavaClass superClass;
        DocletTag tag = javaClass.getTagByName(tagName);
        if (tag == null && (superClass = javaClass.getSuperJavaClass()) != null) {
            tag = this.findInClassHierarchy(superClass, tagName);
        }
        return tag;
    }

    private Map<String, JavaField> extractFieldParameterTags(JavaClass javaClass, Map<String, JavaClass> javaClassesMap) {
        JavaField[] classFields;
        Map<Object, Object> rawParams = new TreeMap();
        JavaClass superClass = javaClass.getSuperJavaClass();
        if (superClass != null) {
            if (superClass.getFields().length > 0) {
                rawParams = this.extractFieldParameterTags(superClass, javaClassesMap);
            }
            if ((superClass = javaClassesMap.get(superClass.getFullyQualifiedName())) != null) {
                rawParams = this.extractFieldParameterTags(superClass, javaClassesMap);
            }
        } else {
            rawParams = new TreeMap();
        }
        if ((classFields = javaClass.getFields()) != null) {
            for (JavaField field : classFields) {
                rawParams.put(field.getName(), field);
            }
        }
        return rawParams;
    }

    protected Map<String, JavaClass> discoverClasses(PluginToolsRequest request) {
        return this.discoverClasses(request.getEncoding(), request.getProject());
    }

    protected Map<String, JavaClass> discoverClasses(String encoding, MavenProject project) {
        ArrayList<File> sources = new ArrayList<File>();
        for (String source : project.getCompileSourceRoots()) {
            sources.add(new File(source));
        }
        File generatedPlugin = new File(project.getBasedir(), "target/generated-sources/plugin");
        if (!project.getCompileSourceRoots().contains(generatedPlugin.getAbsolutePath()) && generatedPlugin.exists()) {
            sources.add(generatedPlugin);
        }
        return this.discoverClasses(encoding, sources);
    }

    protected Map<String, JavaClass> discoverClasses(String encoding, List<File> sourceDirectories) {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.setEncoding(encoding);
        for (File source : sourceDirectories) {
            builder.addSourceTree(source);
        }
        JavaClass[] javaClasses = builder.getClasses();
        if (javaClasses == null || javaClasses.length < 1) {
            return Collections.emptyMap();
        }
        HashMap<String, JavaClass> javaClassMap = new HashMap<String, JavaClass>(javaClasses.length);
        for (JavaClass javaClass : javaClasses) {
            javaClassMap.put(javaClass.getFullyQualifiedName(), javaClass);
        }
        return javaClassMap;
    }

    private List<MojoDescriptor> toMojoDescriptors(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, PluginDescriptor pluginDescriptor) throws DuplicateParameterException, InvalidParameterException {
        ArrayList<MojoDescriptor> mojoDescriptors = new ArrayList<MojoDescriptor>(mojoAnnotatedClasses.size());
        for (MojoAnnotatedClass mojoAnnotatedClass : mojoAnnotatedClasses.values()) {
            if (mojoAnnotatedClass.getMojo() == null) continue;
            ExtendedMojoDescriptor mojoDescriptor = new ExtendedMojoDescriptor();
            mojoDescriptor.setImplementation(mojoAnnotatedClass.getClassName());
            mojoDescriptor.setLanguage("java");
            MojoAnnotationContent mojo = mojoAnnotatedClass.getMojo();
            mojoDescriptor.setDescription(mojo.getDescription());
            mojoDescriptor.setSince(mojo.getSince());
            mojo.setDeprecated(mojo.getDeprecated());
            mojoDescriptor.setProjectRequired(mojo.requiresProject());
            mojoDescriptor.setRequiresReports(mojo.requiresReports());
            mojoDescriptor.setComponentConfigurator(mojo.configurator());
            mojoDescriptor.setInheritedByDefault(mojo.inheritByDefault());
            String instantiationStrategy = mojo.instantiationStrategy().id();
            if (instantiationStrategy == null) {
                instantiationStrategy = mojo.instanciationStrategy().id();
            }
            mojoDescriptor.setInstantiationStrategy(instantiationStrategy);
            mojoDescriptor.setAggregator(mojo.aggregator());
            mojoDescriptor.setDependencyResolutionRequired(mojo.requiresDependencyResolution().id());
            mojoDescriptor.setDependencyCollectionRequired(mojo.requiresDependencyCollection().id());
            mojoDescriptor.setDirectInvocationOnly(mojo.requiresDirectInvocation());
            mojoDescriptor.setDeprecated(mojo.getDeprecated());
            mojoDescriptor.setThreadSafe(mojo.threadSafe());
            ExecuteAnnotationContent execute = this.findExecuteInParentHierarchy(mojoAnnotatedClass, mojoAnnotatedClasses);
            if (execute != null) {
                mojoDescriptor.setExecuteGoal(execute.goal());
                mojoDescriptor.setExecuteLifecycle(execute.lifecycle());
                if (execute.phase() != null) {
                    mojoDescriptor.setExecutePhase(execute.phase().id());
                }
            }
            mojoDescriptor.setExecutionStrategy(mojo.executionStrategy());
            mojoDescriptor.setGoal(mojo.name());
            mojoDescriptor.setOnlineRequired(mojo.requiresOnline());
            mojoDescriptor.setPhase(mojo.defaultPhase().id());
            Map<String, ParameterAnnotationContent> parameters = this.getParametersParentHierarchy(mojoAnnotatedClass, new HashMap<String, ParameterAnnotationContent>(), mojoAnnotatedClasses);
            for (ParameterAnnotationContent parameterAnnotationContent : new TreeSet<ParameterAnnotationContent>(parameters.values())) {
                Parameter parameter = new Parameter();
                parameter.setName(parameterAnnotationContent.getFieldName());
                parameter.setAlias(parameterAnnotationContent.alias());
                parameter.setDefaultValue(parameterAnnotationContent.defaultValue());
                parameter.setDeprecated(parameterAnnotationContent.getDeprecated());
                parameter.setDescription(parameterAnnotationContent.getDescription());
                parameter.setEditable(!parameterAnnotationContent.readonly());
                String property = parameterAnnotationContent.property();
                if (StringUtils.contains((String)property, (char)'$') || StringUtils.contains((String)property, (char)'{') || StringUtils.contains((String)property, (char)'}')) {
                    throw new InvalidParameterException("Invalid property for parameter '" + parameter.getName() + "', " + "forbidden characters ${}: " + property, null);
                }
                parameter.setExpression(StringUtils.isEmpty((String)property) ? "" : "${" + property + "}");
                parameter.setType(parameterAnnotationContent.getClassName());
                parameter.setSince(parameterAnnotationContent.getSince());
                parameter.setRequired(parameterAnnotationContent.required());
                mojoDescriptor.addParameter(parameter);
            }
            Map<String, ComponentAnnotationContent> components = this.getComponentsParentHierarchy(mojoAnnotatedClass, new HashMap<String, ComponentAnnotationContent>(), mojoAnnotatedClasses);
            for (ComponentAnnotationContent componentAnnotationContent : new TreeSet<ComponentAnnotationContent>(components.values())) {
                Parameter parameter = new Parameter();
                parameter.setName(componentAnnotationContent.getFieldName());
                String expression = (String)PluginUtils.MAVEN_COMPONENTS.get(componentAnnotationContent.getRoleClassName());
                if (expression == null) {
                    parameter.setRequirement(new org.apache.maven.plugin.descriptor.Requirement(componentAnnotationContent.getRoleClassName(), componentAnnotationContent.hint()));
                } else {
                    parameter.setDefaultValue(expression);
                    parameter.setType(componentAnnotationContent.getRoleClassName());
                    parameter.setRequired(true);
                }
                parameter.setDeprecated(componentAnnotationContent.getDeprecated());
                parameter.setSince(componentAnnotationContent.getSince());
                parameter.setEditable(false);
                mojoDescriptor.addParameter(parameter);
            }
            mojoDescriptor.setPluginDescriptor(pluginDescriptor);
            mojoDescriptors.add((MojoDescriptor)mojoDescriptor);
        }
        return mojoDescriptors;
    }

    protected ExecuteAnnotationContent findExecuteInParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        if (mojoAnnotatedClass.getExecute() != null) {
            return mojoAnnotatedClass.getExecute();
        }
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (StringUtils.isEmpty((String)parentClassName)) {
            return null;
        }
        MojoAnnotatedClass parent = mojoAnnotatedClasses.get(parentClassName);
        if (parent == null) {
            return null;
        }
        return this.findExecuteInParentHierarchy(parent, mojoAnnotatedClasses);
    }

    protected Map<String, ParameterAnnotationContent> getParametersParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, ParameterAnnotationContent> parameters, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        List<ParameterAnnotationContent> parameterAnnotationContents = new ArrayList<ParameterAnnotationContent>();
        parameterAnnotationContents = this.getParametersParent(mojoAnnotatedClass, parameterAnnotationContents, mojoAnnotatedClasses);
        Collections.reverse(parameterAnnotationContents);
        HashMap<String, ParameterAnnotationContent> map = new HashMap<String, ParameterAnnotationContent>(parameterAnnotationContents.size());
        for (ParameterAnnotationContent parameterAnnotationContent : parameterAnnotationContents) {
            map.put(parameterAnnotationContent.getFieldName(), parameterAnnotationContent);
        }
        return map;
    }

    protected List<ParameterAnnotationContent> getParametersParent(MojoAnnotatedClass mojoAnnotatedClass, List<ParameterAnnotationContent> parameterAnnotationContents, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        MojoAnnotatedClass parent;
        parameterAnnotationContents.addAll(mojoAnnotatedClass.getParameters().values());
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (parentClassName != null && (parent = mojoAnnotatedClasses.get(parentClassName)) != null) {
            return this.getParametersParent(parent, parameterAnnotationContents, mojoAnnotatedClasses);
        }
        return parameterAnnotationContents;
    }

    protected Map<String, ComponentAnnotationContent> getComponentsParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, ComponentAnnotationContent> components, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        List<ComponentAnnotationContent> componentAnnotationContents = new ArrayList<ComponentAnnotationContent>();
        componentAnnotationContents = this.getComponentParent(mojoAnnotatedClass, componentAnnotationContents, mojoAnnotatedClasses);
        Collections.reverse(componentAnnotationContents);
        HashMap<String, ComponentAnnotationContent> map = new HashMap<String, ComponentAnnotationContent>(componentAnnotationContents.size());
        for (ComponentAnnotationContent componentAnnotationContent : componentAnnotationContents) {
            map.put(componentAnnotationContent.getFieldName(), componentAnnotationContent);
        }
        return map;
    }

    protected List<ComponentAnnotationContent> getComponentParent(MojoAnnotatedClass mojoAnnotatedClass, List<ComponentAnnotationContent> componentAnnotationContents, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        MojoAnnotatedClass parent;
        componentAnnotationContents.addAll(mojoAnnotatedClass.getComponents().values());
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (parentClassName != null && (parent = mojoAnnotatedClasses.get(parentClassName)) != null) {
            return this.getComponentParent(parent, componentAnnotationContents, mojoAnnotatedClasses);
        }
        return componentAnnotationContents;
    }

    protected MavenProject getFromProjectReferences(Artifact artifact, MavenProject project) {
        if (project.getProjectReferences() == null || project.getProjectReferences().isEmpty()) {
            return null;
        }
        Collection mavenProjects = project.getProjectReferences().values();
        for (MavenProject mavenProject : mavenProjects) {
            if (!StringUtils.equals((String)mavenProject.getId(), (String)artifact.getId())) continue;
            return mavenProject;
        }
        return null;
    }
}

