/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.jline.MessageUtils;
import org.slf4j.simple.ExtSimpleLogger;

public class MavenSimpleLogger
extends ExtSimpleLogger {
    private String traceRenderedLevel;
    private String debugRenderedLevel;
    private String infoRenderedLevel;
    private String warnRenderedLevel;
    private String errorRenderedLevel;
    static Consumer<String> logSink;

    public static void setLogSink(Consumer<String> logSink) {
        MavenSimpleLogger.logSink = logSink;
    }

    MavenSimpleLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int level) {
        if (this.traceRenderedLevel == null) {
            this.traceRenderedLevel = MessageUtils.builder().trace((Object)"TRACE").build();
            this.debugRenderedLevel = MessageUtils.builder().debug((Object)"DEBUG").build();
            this.infoRenderedLevel = MessageUtils.builder().info((Object)"INFO").build();
            this.warnRenderedLevel = MessageUtils.builder().warning((Object)"WARNING").build();
            this.errorRenderedLevel = MessageUtils.builder().error((Object)"ERROR").build();
        }
        switch (level) {
            case 0: {
                return this.traceRenderedLevel;
            }
            case 10: {
                return this.debugRenderedLevel;
            }
            case 20: {
                return this.infoRenderedLevel;
            }
            case 30: {
                return this.warnRenderedLevel;
            }
        }
        return this.errorRenderedLevel;
    }

    @Override
    protected void doWrite(StringBuilder buf, Throwable t) {
        Consumer<String> sink = logSink;
        if (sink != null) {
            sink.accept(buf.toString());
        } else {
            super.doWrite(buf, t);
        }
    }

    @Override
    protected void writeThrowable(Throwable t, PrintStream stream) {
        if (t == null) {
            return;
        }
        MessageBuilder builder = MessageUtils.builder().failure((Object)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ").failure((Object)t.getMessage());
        }
        stream.println(builder);
        this.printStackTrace(t, stream, "");
    }

    private void printStackTrace(Throwable t, PrintStream stream, String prefix) {
        MessageBuilder builder = MessageUtils.builder();
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            builder.a((CharSequence)prefix);
            builder.a((CharSequence)"    ");
            builder.strong((Object)"at");
            builder.a((CharSequence)" ");
            builder.a((CharSequence)stackTraceElement.getClassName());
            builder.a((CharSequence)".");
            builder.a((CharSequence)stackTraceElement.getMethodName());
            builder.a((CharSequence)"(");
            builder.strong((Object)this.getLocation(stackTraceElement));
            builder.a((CharSequence)")");
            stream.println(builder);
            builder.setLength(0);
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, stream, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null && t != cause) {
            this.writeThrowable(cause, stream, "Caused by", prefix);
        }
    }

    private void writeThrowable(Throwable t, PrintStream stream, String caption, String prefix) {
        MessageBuilder builder = MessageUtils.builder().a((CharSequence)prefix).strong((Object)caption).a((CharSequence)": ").a((CharSequence)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ").failure((Object)t.getMessage());
        }
        stream.println(builder);
        this.printStackTrace(t, stream, prefix);
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return e.getFileName() + ":" + e.getLineNumber();
        }
        return e.getFileName();
    }
}

