/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.util.Optional;
import org.apache.maven.logwrapper.LogLevelRecorder;
import org.apache.maven.logwrapper.MavenSlf4jWrapperFactory;
import org.apache.maven.slf4j.MavenFailOnSeverityLogger;
import org.apache.maven.slf4j.MavenSimpleLogger;
import org.slf4j.Logger;
import org.slf4j.simple.SimpleLoggerFactory;

public class MavenLoggerFactory
extends SimpleLoggerFactory
implements MavenSlf4jWrapperFactory {
    private LogLevelRecorder logLevelRecorder = null;

    public void setLogLevelRecorder(LogLevelRecorder logLevelRecorder) {
        if (this.logLevelRecorder != null) {
            throw new IllegalStateException("LogLevelRecorder has already been set.");
        }
        this.logLevelRecorder = logLevelRecorder;
        this.reset();
    }

    public Optional<LogLevelRecorder> getLogLevelRecorder() {
        return Optional.ofNullable(this.logLevelRecorder);
    }

    @Override
    protected Logger createLogger(String name) {
        if (this.logLevelRecorder == null) {
            return new MavenSimpleLogger(name);
        }
        return new MavenFailOnSeverityLogger(name, this.logLevelRecorder);
    }
}

