/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.cli.jansi.MessageUtils;
import org.slf4j.impl.SimpleLogger;

public class MavenSimpleLogger
extends SimpleLogger {
    MavenSimpleLogger(String name) {
        super(name);
    }

    @Override
    protected String renderLevel(int level) {
        switch (level) {
            case 0: {
                return this.builder().debug((Object)"TRACE").build();
            }
            case 10: {
                return this.builder().debug((Object)"DEBUG").build();
            }
            case 20: {
                return this.builder().info((Object)"INFO").build();
            }
            case 30: {
                return this.builder().warning((Object)"WARNING").build();
            }
        }
        return this.builder().error((Object)"ERROR").build();
    }

    @Override
    protected void writeThrowable(Throwable t, PrintStream stream) {
        if (t == null) {
            return;
        }
        stream.print(this.builder().failure((Object)t.getClass().getName()));
        if (t.getMessage() != null) {
            stream.print(": ");
            stream.print(this.builder().failure((Object)t.getMessage()));
        }
        stream.println();
        this.printStackTrace(t, stream, "");
    }

    private void printStackTrace(Throwable t, PrintStream stream, String prefix) {
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            stream.print(prefix);
            stream.print("    ");
            stream.print(this.builder().strong((Object)"at"));
            stream.print(" " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
            stream.print(this.builder().a((CharSequence)" (").strong((Object)this.getLocation(stackTraceElement)).a((CharSequence)")"));
            stream.println();
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, stream, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.writeThrowable(cause, stream, "Caused by", prefix);
        }
    }

    private void writeThrowable(Throwable t, PrintStream stream, String caption, String prefix) {
        stream.print(this.builder().a((CharSequence)prefix).strong((Object)caption).a((CharSequence)": ").a((CharSequence)t.getClass().getName()));
        if (t.getMessage() != null) {
            stream.print(": ");
            stream.print(this.builder().failure((Object)t.getMessage()));
        }
        stream.println();
        this.printStackTrace(t, stream, prefix);
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }

    private MessageBuilder builder() {
        return MessageUtils.builder();
    }
}

