/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.settings;

/**
 * 
 *         
 *         Repository contains the information needed
 *         for establishing connections with remote repository
 *         
 *       .
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class RepositoryBase
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             A unique identifier for a repository.
     *             
     *           
     */
    private String id;

    /**
     * 
     *             
     *             Human readable name of the repository.
     *             
     *           
     */
    private String name;

    /**
     * 
     *             
     *             The url of the repository.
     *             
     *           
     */
    private String url;

    /**
     * 
     *             The type of layout this repository uses for
     * locating and
     *             storing artifacts - can be "legacy" or
     * "default".
     *           
     */
    private String layout = "default";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return RepositoryBase
     */
    public RepositoryBase clone()
    {
        try
        {
            RepositoryBase copy = (RepositoryBase) super.clone();

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- RepositoryBase clone()

    /**
     * Get a unique identifier for a repository.
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Get the type of layout this repository uses for locating and
     *             storing artifacts - can be "legacy" or
     * "default".
     * 
     * @return String
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout()

    /**
     * Get human readable name of the repository.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the url of the repository.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Set a unique identifier for a repository.
     * 
     * @param id a id object.
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set the type of layout this repository uses for locating and
     *             storing artifacts - can be "legacy" or
     * "default".
     * 
     * @param layout a layout object.
     */
    public void setLayout( String layout )
    {
        this.layout = layout;
    } //-- void setLayout( String )

    /**
     * Set human readable name of the repository.
     * 
     * @param name a name object.
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the url of the repository.
     * 
     * @param url a url object.
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    
            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object obj )
    {
        RepositoryBase other =  (RepositoryBase) obj;

        boolean retValue = false;

        if ( id != null )
        {
            retValue = id.equals( other.id );
        }

        return retValue;
    }
            
          
}
