/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.building;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.SettingsBuilderException;
import org.apache.maven.api.services.SettingsBuilderRequest;
import org.apache.maven.api.services.SettingsBuilderResult;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.xml.SettingsXmlFactory;
import org.apache.maven.building.FileSource;
import org.apache.maven.internal.impl.DefaultSettingsXmlFactory;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingResult;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private final org.apache.maven.internal.impl.DefaultSettingsBuilder builder;
    private final DefaultSettingsXmlFactory settingsXmlFactory;

    @Inject
    public DefaultSettingsBuilder(org.apache.maven.internal.impl.DefaultSettingsBuilder builder, DefaultSettingsXmlFactory settingsXmlFactory) {
        this.builder = builder;
        this.settingsXmlFactory = settingsXmlFactory;
    }

    @Override
    public SettingsBuildingResult build(SettingsBuildingRequest request) throws SettingsBuildingException {
        try {
            SettingsBuilderResult result = this.builder.build(SettingsBuilderRequest.builder().session((ProtoSession)((Session)Proxy.newProxyInstance(Session.class.getClassLoader(), new Class[]{Session.class}, (proxy, method, args) -> {
                if ("getSystemProperties".equals(method.getName())) {
                    return request.getSystemProperties().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
                }
                if ("getUserProperties".equals(method.getName())) {
                    return request.getUserProperties().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
                }
                if ("getService".equals(method.getName()) && args[0] == SettingsXmlFactory.class) {
                    return this.settingsXmlFactory;
                }
                return null;
            }))).installationSettingsSource(this.toSource(request.getGlobalSettingsFile(), request.getGlobalSettingsSource())).projectSettingsSource(this.toSource(request.getProjectSettingsFile(), request.getProjectSettingsSource())).userSettingsSource(this.toSource(request.getUserSettingsFile(), request.getUserSettingsSource())).build());
            return new DefaultSettingsBuildingResult(new Settings(result.getEffectiveSettings()), this.convert(result.getProblems().problems().toList()));
        }
        catch (SettingsBuilderException e) {
            throw new SettingsBuildingException(this.convert(e.getProblemCollector().problems().toList()));
        }
    }

    private Source toSource(File file, final org.apache.maven.building.Source source) {
        if (file != null && file.exists()) {
            return Source.fromPath((Path)file.toPath());
        }
        if (source instanceof FileSource) {
            FileSource fs = (FileSource)source;
            return Source.fromPath((Path)fs.getPath());
        }
        if (source != null) {
            return new Source(){

                public Path getPath() {
                    return null;
                }

                public InputStream openStream() throws IOException {
                    return source.getInputStream();
                }

                public String getLocation() {
                    return source.getLocation();
                }

                public Source resolve(String relative) {
                    return null;
                }
            };
        }
        return null;
    }

    private List<SettingsProblem> convert(List<BuilderProblem> problems) {
        return problems.stream().map(this::convert).toList();
    }

    private SettingsProblem convert(BuilderProblem problem) {
        return new DefaultSettingsProblem(problem.getMessage(), SettingsProblem.Severity.valueOf(problem.getSeverity().name()), problem.getSource(), problem.getLineNumber(), problem.getColumnNumber(), problem.getException());
    }
}

