/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.repository.internal.MavenMetadata;
import org.eclipse.aether.metadata.Metadata;

final class PluginsMetadata
extends MavenMetadata {
    private final PluginInfo pluginInfo;

    PluginsMetadata(PluginInfo pluginInfo, Date timestamp) {
        super(PluginsMetadata.createRepositoryMetadata(pluginInfo), (Path)null, timestamp);
        this.pluginInfo = pluginInfo;
    }

    PluginsMetadata(PluginInfo pluginInfo, Path path, Date timestamp) {
        super(PluginsMetadata.createRepositoryMetadata(pluginInfo), path, timestamp);
        this.pluginInfo = pluginInfo;
    }

    private static Metadata createRepositoryMetadata(PluginInfo pluginInfo) {
        Metadata result = new Metadata();
        Plugin plugin = new Plugin();
        plugin.setPrefix(pluginInfo.goalPrefix);
        plugin.setArtifactId(pluginInfo.artifactId);
        plugin.setName(pluginInfo.name);
        result.getPlugins().add(plugin);
        return result;
    }

    @Override
    protected void merge(Metadata recessive) {
        List recessivePlugins = recessive.getPlugins();
        List plugins = this.metadata.getPlugins();
        if (!recessivePlugins.isEmpty() || !plugins.isEmpty()) {
            LinkedHashMap mergedPlugins = new LinkedHashMap();
            recessivePlugins.forEach(p -> mergedPlugins.put(p.getPrefix(), p));
            plugins.forEach(p -> mergedPlugins.put(p.getPrefix(), p));
            this.metadata.setPlugins(new ArrayList(mergedPlugins.values()));
        }
        if (recessive.getVersioning() != null) {
            this.metadata.setVersioning(recessive.getVersioning());
        }
    }

    @Deprecated
    public MavenMetadata setFile(File file) {
        return new PluginsMetadata(this.pluginInfo, file.toPath(), this.timestamp);
    }

    public MavenMetadata setPath(Path path) {
        return new PluginsMetadata(this.pluginInfo, path, this.timestamp);
    }

    public String getGroupId() {
        return this.pluginInfo.groupId;
    }

    public String getArtifactId() {
        return "";
    }

    public String getVersion() {
        return "";
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.RELEASE_OR_SNAPSHOT;
    }

    static final class PluginInfo {
        @Nonnull
        final String groupId;
        @Nonnull
        private final String artifactId;
        @Nullable
        private final String goalPrefix;
        @Nullable
        private final String name;

        PluginInfo(String groupId, String artifactId, String goalPrefix, String name) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.goalPrefix = goalPrefix;
            this.name = name;
        }
    }
}

