/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability.plugin.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.usability.plugin.Expression;
import org.apache.maven.usability.plugin.ExpressionDocumentation;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ParamdocXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, ExpressionDocumentation expressionDocumentation) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(expressionDocumentation.getModelEncoding(), null);
        this.writeExpressionDocumentation(expressionDocumentation, "paramdoc", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeExpression(Expression expression, String tagName, XmlSerializer serializer) throws IOException {
        if (expression != null) {
            String value;
            String key;
            Iterator<Object> iter;
            serializer.startTag(NAMESPACE, tagName);
            if (expression.getSyntax() != null) {
                serializer.startTag(NAMESPACE, "syntax").text(expression.getSyntax()).endTag(NAMESPACE, "syntax");
            }
            if (expression.getDescription() != null) {
                serializer.startTag(NAMESPACE, "description").text(expression.getDescription()).endTag(NAMESPACE, "description");
            }
            if (expression.getConfiguration() != null) {
                serializer.startTag(NAMESPACE, "configuration").text(expression.getConfiguration()).endTag(NAMESPACE, "configuration");
            }
            if (expression.getCliOptions() != null && expression.getCliOptions().size() > 0) {
                serializer.startTag(NAMESPACE, "cliOptions");
                iter = expression.getCliOptions().keySet().iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    value = (String)expression.getCliOptions().get(key);
                    serializer.startTag(NAMESPACE, "cliOption");
                    serializer.startTag(NAMESPACE, "key").text(key).endTag(NAMESPACE, "key");
                    serializer.startTag(NAMESPACE, "value").text(value).endTag(NAMESPACE, "value");
                    serializer.endTag(NAMESPACE, "cliOption");
                }
                serializer.endTag(NAMESPACE, "cliOptions");
            }
            if (expression.getApiMethods() != null && expression.getApiMethods().size() > 0) {
                serializer.startTag(NAMESPACE, "apiMethods");
                iter = expression.getApiMethods().keySet().iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    value = (String)expression.getApiMethods().get(key);
                    serializer.startTag(NAMESPACE, "apiMethod");
                    serializer.startTag(NAMESPACE, "key").text(key).endTag(NAMESPACE, "key");
                    serializer.startTag(NAMESPACE, "value").text(value).endTag(NAMESPACE, "value");
                    serializer.endTag(NAMESPACE, "apiMethod");
                }
                serializer.endTag(NAMESPACE, "apiMethods");
            }
            if (expression.getDeprecation() != null) {
                serializer.startTag(NAMESPACE, "deprecation").text(expression.getDeprecation()).endTag(NAMESPACE, "deprecation");
            }
            if (expression.getBan() != null) {
                serializer.startTag(NAMESPACE, "ban").text(expression.getBan()).endTag(NAMESPACE, "ban");
            }
            if (!expression.isEditable()) {
                serializer.startTag(NAMESPACE, "editable").text(String.valueOf(expression.isEditable())).endTag(NAMESPACE, "editable");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeExpressionDocumentation(ExpressionDocumentation expressionDocumentation, String tagName, XmlSerializer serializer) throws IOException {
        if (expressionDocumentation != null) {
            serializer.setPrefix("", "http://maven.apache.org/PARAMDOC/1.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.startTag(NAMESPACE, tagName);
            serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/PARAMDOC/1.0.0 http://maven.apache.org/xsd/paramdoc-1.0.0.xsd");
            if (expressionDocumentation.getExpressions() != null && expressionDocumentation.getExpressions().size() > 0) {
                serializer.startTag(NAMESPACE, "expressions");
                Iterator iter = expressionDocumentation.getExpressions().iterator();
                while (iter.hasNext()) {
                    Expression o = (Expression)iter.next();
                    this.writeExpression(o, "expression", serializer);
                }
                serializer.endTag(NAMESPACE, "expressions");
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }
}

