/*
 * $Id$
 */

package org.apache.maven.plugin.lifecycle;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A set of goals to execute.
 * 
 * @version $Revision$ $Date$
 */
public class Execution implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field configuration
     */
    private Object configuration;

    /**
     * Field goals
     */
    private java.util.List goals;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addGoal
     * 
     * @param string
     */
    public void addGoal(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Execution.addGoals(string) parameter must be instanceof " + String.class.getName() );
        }
        getGoals().add( string );
    } //-- void addGoal(String) 

    /**
     * Get Configuration to pass to the goals.
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Method getGoals
     */
    public java.util.List getGoals()
    {
        if ( this.goals == null )
        {
            this.goals = new java.util.ArrayList();
        }
        
        return this.goals;
    } //-- java.util.List getGoals() 

    /**
     * Method removeGoal
     * 
     * @param string
     */
    public void removeGoal(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Execution.removeGoals(string) parameter must be instanceof " + String.class.getName() );
        }
        getGoals().remove( string );
    } //-- void removeGoal(String) 

    /**
     * Set Configuration to pass to the goals.
     * 
     * @param configuration
     */
    public void setConfiguration(Object configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(Object) 

    /**
     * Set The goals to execute.
     * 
     * @param goals
     */
    public void setGoals(java.util.List goals)
    {
        this.goals = goals;
    } //-- void setGoals(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
