/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.util.List;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.apache.maven.model.transform.pull.NodeBufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class RelativePathXMLFilter
extends NodeBufferingParser {
    public RelativePathXMLFilter(XmlPullParser xmlPullParser) {
        super(xmlPullParser, "parent");
    }

    @Override
    protected void process(List<BufferingParser.Event> buffer) {
        boolean skip = false;
        BufferingParser.Event prev = null;
        for (BufferingParser.Event event : buffer) {
            if (event.event == 2 && "relativePath".equals(event.name)) {
                skip = true;
                if (prev != null && prev.event == 4 && prev.text.matches("\\s+")) {
                    prev = null;
                }
                event = null;
            } else if (event.event == 3 && "relativePath".equals(event.name)) {
                skip = false;
                event = null;
            } else if (skip) {
                event = null;
            }
            if (prev != null) {
                this.pushEvent(prev);
            }
            prev = event;
        }
        this.pushEvent(prev);
    }
}

