/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform.pull;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BufferingParser
implements XmlPullParser {
    protected XmlPullParser xmlPullParser;
    protected Deque<Event> events;
    protected Event current;
    protected boolean disabled;

    public BufferingParser(XmlPullParser xmlPullParser) {
        this.xmlPullParser = xmlPullParser;
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        this.xmlPullParser.setFeature(name, state);
    }

    public boolean getFeature(String name) {
        return this.xmlPullParser.getFeature(name);
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        this.xmlPullParser.setProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.xmlPullParser.getProperty(name);
    }

    public void setInput(Reader in) throws XmlPullParserException {
        this.xmlPullParser.setInput(in);
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.xmlPullParser.setInput(inputStream, inputEncoding);
    }

    public String getInputEncoding() {
        return this.xmlPullParser.getInputEncoding();
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        this.xmlPullParser.defineEntityReplacementText(entityName, replacementText);
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        return this.xmlPullParser.getNamespaceCount(depth);
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        return this.xmlPullParser.getNamespacePrefix(pos);
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        return this.xmlPullParser.getNamespaceUri(pos);
    }

    public String getNamespace(String prefix) {
        return this.xmlPullParser.getNamespace(prefix);
    }

    public int getDepth() {
        return this.xmlPullParser.getDepth();
    }

    public String getPositionDescription() {
        if (this.current != null) {
            throw new IllegalStateException("Not supported during events replay");
        }
        return this.xmlPullParser.getPositionDescription();
    }

    public int getLineNumber() {
        if (this.current != null) {
            throw new IllegalStateException("Not supported during events replay");
        }
        return this.xmlPullParser.getLineNumber();
    }

    public int getColumnNumber() {
        if (this.current != null) {
            throw new IllegalStateException("Not supported during events replay");
        }
        return this.xmlPullParser.getColumnNumber();
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.current != null) {
            if (this.current.event == 4 || this.current.event == 5) {
                return this.current.text.matches("[ \r\t\n]+");
            }
            if (this.current.event == 7) {
                return true;
            }
            throw new XmlPullParserException("no content available to check for whitespaces");
        }
        return this.xmlPullParser.isWhitespace();
    }

    public String getText() {
        return this.current != null ? this.current.text : this.xmlPullParser.getText();
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        if (this.current != null) {
            throw new IllegalStateException("Not supported during events replay");
        }
        return this.xmlPullParser.getTextCharacters(holderForStartAndLength);
    }

    public String getNamespace() {
        return this.current != null ? this.current.namespace : this.xmlPullParser.getNamespace();
    }

    public String getName() {
        return this.current != null ? this.current.name : this.xmlPullParser.getName();
    }

    public String getPrefix() {
        return this.current != null ? this.current.prefix : this.xmlPullParser.getPrefix();
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        return this.current != null ? this.current.empty : this.xmlPullParser.isEmptyElementTag();
    }

    public int getAttributeCount() {
        if (this.current != null) {
            return this.current.attributes != null ? this.current.attributes.length : 0;
        }
        return this.xmlPullParser.getAttributeCount();
    }

    public String getAttributeNamespace(int index) {
        if (this.current != null) {
            return this.current.attributes[index].namespace;
        }
        return this.xmlPullParser.getAttributeNamespace(index);
    }

    public String getAttributeName(int index) {
        if (this.current != null) {
            return this.current.attributes[index].name;
        }
        return this.xmlPullParser.getAttributeName(index);
    }

    public String getAttributePrefix(int index) {
        if (this.current != null) {
            return this.current.attributes[index].prefix;
        }
        return this.xmlPullParser.getAttributePrefix(index);
    }

    public String getAttributeType(int index) {
        if (this.current != null) {
            return this.current.attributes[index].type;
        }
        return this.xmlPullParser.getAttributeType(index);
    }

    public boolean isAttributeDefault(int index) {
        if (this.current != null) {
            return this.current.attributes[index].isDefault;
        }
        return this.xmlPullParser.isAttributeDefault(index);
    }

    public String getAttributeValue(int index) {
        if (this.current != null) {
            return this.current.attributes[index].value;
        }
        return this.xmlPullParser.getAttributeValue(index);
    }

    public String getAttributeValue(String namespace, String name) {
        if (this.current != null) {
            if (this.current.attributes != null) {
                for (Attribute attr : this.current.attributes) {
                    if (!Objects.equals(namespace, attr.namespace) || !Objects.equals(name, attr.name)) continue;
                    return attr.value;
                }
            }
            return null;
        }
        return this.xmlPullParser.getAttributeValue(namespace, name);
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (this.current != null) {
            throw new IllegalStateException("Not supported during events replay");
        }
        this.xmlPullParser.require(type, namespace, name);
    }

    public int getEventType() throws XmlPullParserException {
        return this.current != null ? this.current.event : this.xmlPullParser.getEventType();
    }

    public int next() throws XmlPullParserException, IOException {
        int currentEvent;
        do {
            if (this.events != null && !this.events.isEmpty()) {
                this.current = this.events.removeFirst();
                return this.current.event;
            }
            this.current = null;
            if (this.getEventType() == 1) {
                throw new XmlPullParserException("already reached end of XML input", (XmlPullParser)this, null);
            }
            currentEvent = this.xmlPullParser.next();
        } while (!this.disabled && !this.accept());
        return currentEvent;
    }

    public int nextToken() throws XmlPullParserException, IOException {
        int currentEvent;
        do {
            if (this.events != null && !this.events.isEmpty()) {
                this.current = this.events.removeFirst();
                return this.current.event;
            }
            this.current = null;
            if (this.getEventType() == 1) {
                throw new XmlPullParserException("already reached end of XML input", (XmlPullParser)this, null);
            }
            currentEvent = this.xmlPullParser.nextToken();
        } while (!this.accept());
        return currentEvent;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + TYPES[this.getEventType()], (XmlPullParser)this, null);
        }
        return eventType;
    }

    public String nextText() throws XmlPullParserException, IOException {
        int eventType = this.getEventType();
        if (eventType != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", (XmlPullParser)this, null);
        }
        eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException("TEXT must be immediately followed by END_TAG and not " + TYPES[this.getEventType()], (XmlPullParser)this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", (XmlPullParser)this, null);
    }

    protected Event bufferEvent() throws XmlPullParserException {
        Event event = new Event();
        XmlPullParser pp = this.xmlPullParser;
        event.event = this.xmlPullParser.getEventType();
        switch (event.event) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                event.name = pp.getName();
                event.namespace = pp.getNamespace();
                event.prefix = pp.getPrefix();
                event.empty = pp.isEmptyElementTag();
                event.text = pp.getText();
                break;
            }
            case 3: {
                event.name = pp.getName();
                event.namespace = pp.getNamespace();
                event.prefix = pp.getPrefix();
                event.text = pp.getText();
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                event.text = pp.getText();
                break;
            }
        }
        return event;
    }

    protected void pushEvent(Event event) {
        if (this.events == null) {
            this.events = new ArrayDeque<Event>();
        }
        this.events.add(event);
    }

    protected boolean accept() throws XmlPullParserException, IOException {
        return true;
    }

    protected void enable() {
        this.disabled = false;
    }

    protected void disable() {
        if (this.events != null && !this.events.isEmpty()) {
            throw new IllegalStateException("Can not disable filter while processing");
        }
        this.disabled = true;
        if (this.xmlPullParser instanceof BufferingParser) {
            ((BufferingParser)this.xmlPullParser).disable();
        }
    }

    protected static String nullSafeAppend(String originalValue, String charSegment) {
        if (originalValue == null) {
            return charSegment;
        }
        return originalValue + charSegment;
    }

    public static class Attribute {
        public String name;
        public String prefix;
        public String namespace;
        public String type;
        public String value;
        public boolean isDefault;
    }

    public static class Namespace {
        public String prefix;
        public String uri;
    }

    public static class Event {
        public int event;
        public String name;
        public String prefix;
        public String namespace;
        public boolean empty;
        public String text;
        public Attribute[] attributes;
        public Namespace[] namespaces;
    }
}

