/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class FastForwardFilter
extends BufferingParser {
    private final Deque<String> state = new ArrayDeque<String>();
    private int domDepth = 0;

    FastForwardFilter(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    @Override
    protected boolean accept() throws XmlPullParserException, IOException {
        if (this.xmlPullParser.getEventType() == 2) {
            String localName = this.xmlPullParser.getName();
            if (this.domDepth > 0) {
                ++this.domDepth;
            } else {
                String key;
                switch (key = this.state.peek() + '/' + localName) {
                    case "execution/configuration": 
                    case "plugin/configuration": 
                    case "plugin/goals": 
                    case "profile/reports": 
                    case "project/reports": 
                    case "reportSet/configuration": {
                        ++this.domDepth;
                        this.disable();
                        break;
                    }
                }
            }
            this.state.add(localName);
        } else if (this.xmlPullParser.getEventType() == 3) {
            --this.domDepth;
            if (this.domDepth == 0) {
                this.enable();
            }
            this.state.pop();
        }
        return true;
    }
}

