/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.maven.model.transform.CiFriendlyXMLFilter;
import org.apache.maven.model.transform.ParentXMLFilter;
import org.apache.maven.model.transform.ReactorDependencyXMLFilter;
import org.apache.maven.model.transform.RelativeProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

public class BuildToRawPomXMLFilterFactory {
    private final boolean consume;

    public BuildToRawPomXMLFilterFactory() {
        this(false);
    }

    public BuildToRawPomXMLFilterFactory(boolean consume) {
        this.consume = consume;
    }

    public final XmlPullParser get(XmlPullParser orgParser, Path projectFile) {
        XmlPullParser parser = orgParser;
        if (this.getDependencyKeyToVersionMapper() != null) {
            parser = new ReactorDependencyXMLFilter(parser, this.getDependencyKeyToVersionMapper());
        }
        if (this.getRelativePathMapper() != null) {
            parser = new ParentXMLFilter(parser, this.getRelativePathMapper(), projectFile.getParent());
        }
        CiFriendlyXMLFilter ciFriendlyFilter = new CiFriendlyXMLFilter(parser, this.consume);
        this.getChangelist().ifPresent(ciFriendlyFilter::setChangelist);
        this.getRevision().ifPresent(ciFriendlyFilter::setRevision);
        this.getSha1().ifPresent(ciFriendlyFilter::setSha1);
        parser = ciFriendlyFilter;
        return parser;
    }

    protected Function<Path, Optional<RelativeProject>> getRelativePathMapper() {
        return null;
    }

    protected BiFunction<String, String, String> getDependencyKeyToVersionMapper() {
        return null;
    }

    protected Optional<String> getChangelist() {
        return Optional.empty();
    }

    protected Optional<String> getRevision() {
        return Optional.empty();
    }

    protected Optional<String> getSha1() {
        return Optional.empty();
    }
}

