/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelSourceTransformer;
import org.apache.maven.model.building.TransformerContext;

@Named
@Singleton
@Deprecated(since="4.0.0")
class BuildModelSourceTransformer
implements ModelSourceTransformer {
    public static final String NAMESPACE_PREFIX = "http://maven.apache.org/POM/";

    BuildModelSourceTransformer() {
    }

    @Override
    public void transform(Path pomFile, TransformerContext context, Model model) {
        this.handleModelVersion(model);
        this.handleParent(pomFile, context, model);
        this.handleReactorDependencies(context, model);
        this.handleCiFriendlyVersion(context, model);
    }

    void handleModelVersion(Model model) {
        String namespace = model.getDelegate().getNamespaceUri();
        if (model.getModelVersion() == null && namespace != null && namespace.startsWith(NAMESPACE_PREFIX)) {
            model.setModelVersion(namespace.substring(NAMESPACE_PREFIX.length()));
        }
    }

    void handleParent(Path pomFile, TransformerContext context, Model model) {
        Parent parent = model.getParent();
        if (parent != null) {
            String version = parent.getVersion();
            String path = Optional.ofNullable(parent.getRelativePath()).orElse("..");
            if (version == null && !path.isEmpty()) {
                Optional<RelativeProject> resolvedParent = this.resolveRelativePath(pomFile, context, Paths.get(path, new String[0]), parent.getGroupId(), parent.getArtifactId());
                resolvedParent.ifPresent(relativeProject -> parent.setVersion(relativeProject.getVersion()));
            }
        }
    }

    void handleCiFriendlyVersion(TransformerContext context, Model model) {
        String version = model.getVersion();
        String modVersion = this.replaceCiFriendlyVersion(context, version);
        model.setVersion(modVersion);
        Parent parent = model.getParent();
        if (parent != null) {
            version = parent.getVersion();
            modVersion = this.replaceCiFriendlyVersion(context, version);
            parent.setVersion(modVersion);
        }
    }

    void handleReactorDependencies(TransformerContext context, Model model) {
        for (Dependency dep : model.getDependencies()) {
            Model depModel;
            if (dep.getVersion() != null || (depModel = context.getRawModel(model.getDelegate().getPomFile(), dep.getGroupId(), dep.getArtifactId())) == null) continue;
            String v = depModel.getVersion();
            if (v == null && depModel.getParent() != null) {
                v = depModel.getParent().getVersion();
            }
            dep.setVersion(v);
        }
    }

    protected String replaceCiFriendlyVersion(TransformerContext context, String version) {
        if (version != null) {
            for (String key : Arrays.asList("changelist", "revision", "sha1")) {
                String val = context.getUserProperty(key);
                if (val == null) continue;
                version = version.replace("${" + key + "}", val);
            }
        }
        return version;
    }

    protected Optional<RelativeProject> resolveRelativePath(Path pomFile, TransformerContext context, Path relativePath, String groupId, String artifactId) {
        RelativeProject project;
        Path pomPath = pomFile.resolveSibling(relativePath).normalize();
        if (Files.isDirectory(pomPath, new LinkOption[0])) {
            pomPath = context.locate(pomPath);
        }
        if (pomPath == null || !Files.isRegularFile(pomPath, new LinkOption[0])) {
            return Optional.empty();
        }
        Optional<RelativeProject> mappedProject = Optional.ofNullable(context.getRawModel(pomFile, pomPath.normalize())).map(BuildModelSourceTransformer::toRelativeProject);
        if (mappedProject.isPresent() && Objects.equals(groupId, (project = mappedProject.get()).getGroupId()) && Objects.equals(artifactId, project.getArtifactId())) {
            return mappedProject;
        }
        return Optional.empty();
    }

    private static RelativeProject toRelativeProject(Model m) {
        String version;
        String groupId = m.getGroupId();
        if (groupId == null && m.getParent() != null) {
            groupId = m.getParent().getGroupId();
        }
        if ((version = m.getVersion()) == null && m.getParent() != null) {
            version = m.getParent().getVersion();
        }
        return new RelativeProject(groupId, m.getArtifactId(), version);
    }

    static class RelativeProject {
        private final String groupId;
        private final String artifactId;
        private final String version;

        RelativeProject(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

