/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelSourceTransformer;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultModelReader
implements ModelReader {
    private final ModelSourceTransformer transformer;
    private Method readMethod;
    private Method readMethodEx;

    @Inject
    public DefaultModelReader(ModelSourceTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public Model read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (XmlStreamReader in = ReaderFactory.newXmlReader((File)input);){
            Model model = this.read((Reader)in, input.toPath(), options);
            model.setPomFile(input);
            Model model2 = model;
            return model2;
        }
    }

    @Override
    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            Model model = this.read(in, null, options);
            return model;
        }
    }

    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (XmlStreamReader in = ReaderFactory.newXmlReader((InputStream)input);){
            Model model = this.read((Reader)in, null, options);
            return model;
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }

    private InputSource getSource(Map<String, ?> options) {
        Object value = options != null ? options.get("org.apache.maven.model.io.inputSource") : null;
        return value;
    }

    private TransformerContext getTransformerContext(Map<String, ?> options) {
        Object value = options != null ? options.get("transformerContext") : null;
        return value;
    }

    private Model read(Reader reader, Path pomFile, Map<String, ?> options) throws IOException {
        try {
            MXParser parser = new MXParser(EntityReplacementMap.defaultEntityReplacementMap);
            parser.setInput(reader);
            TransformerContext context = this.getTransformerContext(options);
            MXParser transformingParser = context != null ? this.transformer.transform((XmlPullParser)parser, pomFile, context) : parser;
            InputSource source = this.getSource(options);
            boolean strict = this.isStrict(options);
            try {
                if (source != null) {
                    return this.readModelEx((XmlPullParser)transformingParser, source, strict);
                }
                return this.readModel((XmlPullParser)transformingParser, strict);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Unable to transform pom", e);
        }
    }

    private Model readModel(XmlPullParser parser, boolean strict) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.readMethod == null) {
            this.readMethod = MavenXpp3Reader.class.getDeclaredMethod("read", XmlPullParser.class, Boolean.TYPE);
            this.readMethod.setAccessible(true);
        }
        MavenXpp3Reader mr = new MavenXpp3Reader();
        Object model = this.readMethod.invoke((Object)mr, parser, strict);
        return (Model)model;
    }

    private Model readModelEx(XmlPullParser parser, InputSource source, boolean strict) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.readMethodEx == null) {
            this.readMethodEx = MavenXpp3ReaderEx.class.getDeclaredMethod("read", XmlPullParser.class, Boolean.TYPE, InputSource.class);
            this.readMethodEx.setAccessible(true);
        }
        MavenXpp3ReaderEx mr = new MavenXpp3ReaderEx();
        Object model = this.readMethodEx.invoke((Object)mr, parser, strict, source);
        return (Model)model;
    }
}

