/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationException;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ProfileActivator.class, hint="property")
public class PropertyProfileActivator
implements ProfileActivator {
    public boolean isActive(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        ActivationProperty property;
        boolean active = false;
        Activation activation = profile.getActivation();
        if (activation != null && (property = activation.getProperty()) != null) {
            String propValue;
            String sysValue;
            String name = property.getName();
            boolean reverseName = false;
            if (name == null) {
                throw new ProfileActivationException("The property name is required to activate the profile " + profile.getId(), profile);
            }
            if (name.startsWith("!")) {
                reverseName = true;
                name = name.substring(1);
            }
            if ((sysValue = context.getUserProperties().getProperty(name)) == null) {
                sysValue = context.getSystemProperties().getProperty(name);
            }
            if (StringUtils.isNotEmpty((String)(propValue = property.getValue()))) {
                boolean reverseValue = false;
                if (propValue.startsWith("!")) {
                    reverseValue = true;
                    propValue = propValue.substring(1);
                }
                boolean result = propValue.equals(sysValue);
                active = reverseValue ? !result : result;
            } else {
                boolean result = StringUtils.isNotEmpty((String)sysValue);
                active = reverseName ? !result : result;
            }
        }
        return active;
    }
}

