/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultModelProblemCollector
implements ModelProblemCollector {
    private List<ModelProblem> problems;
    private String sourceHint;
    private Model sourceModel;
    private Model rootModel;

    public DefaultModelProblemCollector(List<ModelProblem> problems) {
        this.problems = problems != null ? problems : new ArrayList();
    }

    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public void setSourceHint(String sourceHint) {
        this.sourceHint = sourceHint;
        this.sourceModel = null;
    }

    public void setSourceHint(Model sourceModel) {
        this.sourceModel = sourceModel;
        this.sourceHint = null;
    }

    private String getSourceHint() {
        if (this.sourceHint == null && this.sourceModel != null) {
            this.sourceHint = ModelProblemUtils.toSourceHint(this.sourceModel);
        }
        return this.sourceHint;
    }

    public void setRootModel(Model rootModel) {
        this.rootModel = rootModel;
    }

    public Model getRootModel() {
        return this.rootModel;
    }

    public String getRootModelId() {
        return ModelProblemUtils.toId(this.rootModel);
    }

    public void add(ModelProblem problem) {
        this.problems.add(problem);
    }

    public void addFatalError(String message) {
        this.problems.add(new DefaultModelProblem(message, ModelProblem.Severity.FATAL, this.getSourceHint()));
    }

    public void addFatalError(String message, Exception cause) {
        this.problems.add(new DefaultModelProblem(message, ModelProblem.Severity.FATAL, this.getSourceHint(), cause));
    }

    @Override
    public void addError(String message) {
        this.problems.add(new DefaultModelProblem(message, ModelProblem.Severity.ERROR, this.getSourceHint()));
    }

    @Override
    public void addError(String message, Exception cause) {
        this.problems.add(new DefaultModelProblem(message, ModelProblem.Severity.ERROR, this.getSourceHint(), cause));
    }

    @Override
    public void addWarning(String message) {
        this.problems.add(new DefaultModelProblem(message, ModelProblem.Severity.WARNING, this.getSourceHint()));
    }

    @Override
    public void addWarning(String message, Exception cause) {
        this.problems.add(new DefaultModelProblem(message, ModelProblem.Severity.WARNING, this.getSourceHint(), cause));
    }
}

